//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_simulation_ace3p_plugin_pqACE3PNewBehavior_h
#define smtk_simulation_ace3p_plugin_pqACE3PNewBehavior_h

#include "smtk/PublicPointerDefs.h"

#include "pqReaction.h"

#include <QObject>

class pqACE3PNewReactionInternals;

/// A reaction for creating a new ACE3P project.
class pqACE3PNewReaction : public pqReaction
{
  Q_OBJECT
  typedef pqReaction Superclass;

public:
  /**
  * Constructor. Parent cannot be NULL.
  */
  pqACE3PNewReaction(QAction* parent);

  ~pqACE3PNewReaction();

  void newProject();

signals:
  void projectCreated(smtk::project::ProjectPtr);

protected slots:

protected:
  /**
  * Called when the action is triggered.
  */
  void onTriggered() override { this->newProject(); }

private:
  Q_DISABLE_COPY(pqACE3PNewReaction)
  pqACE3PNewReactionInternals* Internals;
};

/** \brief Add a menu item for writing the state of the resource manager.
  */
class pqACE3PNewBehavior : public QObject
{
  Q_OBJECT
  using Superclass = QObject;

public:
  static pqACE3PNewBehavior* instance(QObject* parent = nullptr);
  ~pqACE3PNewBehavior() override;

protected:
  pqACE3PNewBehavior(QObject* parent = nullptr);

private:
  Q_DISABLE_COPY(pqACE3PNewBehavior);
};

#endif
