//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME pqACE3PAnalysisPanel - display jobs on remote system
// .SECTION Description

#ifndef __ACE3PAnalysisPanels_h
#define __ACE3PAnalysisPanels_h


#include "smtk/extension/qt/qtUIManager.h"

#include <QDockWidget>

class pqSMTKWrapper;
class pqServer;

class pqACE3PAnalysisModel;
class pqACE3PResourceModel;
class QTableView;

class pqACE3PAnalysisPanel : public QDockWidget
{
  Q_OBJECT

public:
  pqACE3PAnalysisPanel(QWidget* parent);
  virtual ~pqACE3PAnalysisPanel();

  // Let the panel display a custom view config, from json or xml.
  void setView(const smtk::view::ConfigurationPtr& view);

signals:
  void projectUpdated(smtk::project::ProjectPtr);
public slots:

protected slots:
  void infoSlot(const QString& msg);
  virtual void sourceAdded(pqSMTKWrapper* mgr, pqServer* server);
  virtual void sourceRemoved(pqSMTKWrapper* mgr, pqServer* server);

protected:
  // pqACE3PAnalysisBrowser* m_browser;
  smtk::view::ConfigurationPtr m_view;
  smtk::extension::qtUIManager* m_viewUIMgr;

private:
  QWidget*              m_mainwidget;
  QVBoxLayout*          m_mainlayout;
  QPushButton*          m_newanalysis;
  QPushButton*          m_copyanalysis;
  pqACE3PAnalysisModel* m_analysismodel;
  QTableView*           m_analysistable;
  QTableView*           m_resourcetable;
  pqACE3PResourceModel* m_resourcemodel;

};

#endif // __ACE3PAnalysisPanels_h
