#include "sketch/Resource.h"
#include "sketch/DefaultStyle.txx"

#include <memory>

int StartingPoint2(int, char**)
{
  using GroupsToPaths = sketch::GroupsToPaths;
  using PathsToCusps = sketch::PathsToCusps;
  using StylesToShapes = sketch::StylesToShapes;

  auto resource = sketch::Resource::create();
  resource->setName("example");

  // Create some nodes.
  auto path1 = resource->create<sketch::Path>();
  auto path2 = resource->create<sketch::Path>();
  auto group = resource->create<sketch::Group>();
  auto plain = resource->create<sketch::Style>();
  auto fancy = resource->create<sketch::Style>();
  path1->setName("path 1");
  path2->setName("path 2");
  group->setName("group");
  plain->setName("plain style");
  fancy->setLineColor({0.6, 0.2, 0.2});
  fancy->setLineThickness(2.0);
  fancy->setName("fancy style");

  // Add some cusp nodes
  auto cusp1 = resource->create<sketch::Cusp>();
  auto cusp2 = resource->create<sketch::Cusp>();
  cusp1->setName("endpoint 1");
  cusp2->setName("endpoint 2");
  path1->outgoing<PathsToCusps>().connect(cusp1);
  path1->outgoing<PathsToCusps>().connect(cusp2);

  // Set point coordinates on the cusps:
  cusp1->setCoordinates({1.0, 0.0});
  cusp2->setCoordinates({2.0, 1.0});

  // Connect the nodes into a graph.
  group->outgoing<GroupsToPaths>().connect(path1);
  group->outgoing<GroupsToPaths>().connect(path2);
  plain->outgoing<StylesToShapes>().connect(path1);
  fancy->outgoing<StylesToShapes>().connect(path2);

  // Dump the resulting graph.
  resource->dump("", "text/vnd.graphviz");
  return 0;
}
