option(SUPERBUILD_SHALLOW_CLONES "Perform shallow clones rather than full clones" ON)
mark_as_advanced(SUPERBUILD_SHALLOW_CLONES)

superbuild_set_revision(smtkace3p
  GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/plugins/ace3p-extensions.git"
  GIT_TAG         "origin/master"
  GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}")

# While the goal is to be consistent with a SHA on ParaView's main fork, CMB
# frequently uses a custom fork of ParaView in order to maintain functionality
# while updating the connections between the two projects. When this happens, it
# is critical that the forked ParaView also push ParaView's tags to the fork,
# since this is how ParaView determines its version (and, resultantly, how it
# names its libraries).
#
# To push ParaView's tags:
#   $ cd <path-to-sb-build-tree>/superbuild/paraview/src
#   $ git remote add kitware https://gitlab.kitware.com/paraview/paraview.git
#   $ git fetch --tags kitware
#   $ git push --tags origin

superbuild_set_selectable_source(paraview
  SELECT git PROMOTE DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/paraview/paraview.git"
    # XXX: When updating, use the date from the commit as shown in `git log`
    # and a short description of why the hash was updated. DO NOT BLINDLY
    # COPY THE COMMIT MESSAGE OF THE SHA. EXPLAIN WHY SMTK/CMB/AEVA NEED
    # THE NEW PARAVIEW VERSION.
    #
    # What: master @ Thu Dec 30 20:09:24 2021 +0000
    # Why:  Coordinate frame widget in ParaView
    GIT_TAG         "fc18a350d06091e8282e525cbb079e9b6f2d92c0"
  SELECT master CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/paraview/paraview.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT for-v6.3.0 CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/paraview.git"
    GIT_TAG         "2c64f2e43b873a399aa2513a24d336470f2cc3b4"
  SELECT for-v21.05.0 CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/paraview.git"
    GIT_TAG         "30de93d5053706afa747511809da5a9ef129c086"
  SELECT for-v21.07 CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/paraview.git"
    GIT_TAG         "f55e64b42c30b33a76ed4140d45a28cd00b8bd67"
  SELECT for-v21.12 CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/paraview.git"
    GIT_TAG         "fd84b6af2167eb5b51e6540fbadc2571150795b5"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-paraview")

# VTK v9.0.1
superbuild_set_selectable_source(vtkonly
  SELECT release PROMOTE DEFAULT
    GIT_REPOSITORY "https://gitlab.kitware.com/vtk/vtk.git"
    GIT_TAG        "v9.0.2"
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/vtk/vtk.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-vtkonly")

superbuild_set_selectable_source(cmb
  SELECT 21.12
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "v21.12.0"
  SELECT 21.07
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "v21.07.0"
  SELECT 21.05.0
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "v21.05.0"
  SELECT 6.3.0
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "v6.3.0"
  SELECT git CUSTOMIZABLE DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-cmb")

superbuild_set_selectable_source(smtk
  SELECT 21.12
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.12.0"
  SELECT 21.11
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.11.0"
  SELECT 21.10
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.10.0"
  SELECT 21.09
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.09.0"
  SELECT 21.07
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.07.0"
  SELECT 21.05.0
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.05.0"
  SELECT 21.04.0
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v21.04.0"
  SELECT 3.3.0
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v3.3.0"
  SELECT git CUSTOMIZABLE DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-smtk")

superbuild_set_revision(cmbworkflows
  GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/simulation-workflows.git"
  GIT_TAG         "origin/master"
  GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_revision(libarchive
  URL     "https://www.paraview.org/files/dependencies/libarchive-3.3.3.tar.gz"
  URL_MD5 4038e366ca5b659dae3efcc744e72120)

superbuild_set_revision(vxl
  GIT_REPOSITORY  "https://gitlab.kitware.com/third-party/vxl.git"
  GIT_TAG         origin/for/cmb
  GIT_SHALLOW     "ON")

superbuild_set_revision(itk
  GIT_REPOSITORY  "https://github.com/InsightSoftwareConsortium/ITK.git"
  # Fix compilation error on Windows
  GIT_TAG         f3b9f273a5c9c7ba4c233099484174f47cd10117
  # Cannot checkout shallow copy of a hash
  # GIT_SHALLOW     "ON"
)

superbuild_set_revision(itkvtkglue
  GIT_REPOSITORY  "https://gitlab.kitware.com/aeva/itkvtkglue.git"
  GIT_TAG         origin/for-aeva)

# Use opencv from Thu Oct 6 13:40:33 2016 +0000
superbuild_set_revision(opencv
  # https://github.com/opencv/opencv.git
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/opencv-dd379ec9fddc1a1886766cf85844a6e18d38c4f1.tar.bz2"
  URL_MD5 19bbd14ed1bd741beccd6d19e444552f)

superbuild_set_revision(gdal
  # https://github.com/judajake/gdal-svn.git
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/gdal-98353693d6f1d607954220b2f8b040375e3d1744.tar.bz2"
  URL_MD5 5aa285dcc856f98ce44020ae1ae192cb)

superbuild_set_revision(eigen
  # https://github.com/eigenteam/eigen-git-mirror/releases/tag/3.3.7
  URL "https://www.computationalmodelbuilder.org/files/dependencies/eigen-git-mirror-3.3.7.tar.gz"
  URL_MD5 77a2c934eaf35943c43ee600a83b72df)

superbuild_set_revision(moab
  # https://bitbucket.org/fathomteam/moab.git
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/moab-6425a480ffe8e08b96453618fc5530e08e68ae8a.tar.bz2"
  URL_MD5 5946a405cddce972d54044fca6c87b11)

superbuild_set_revision(triangle
  # https://github.com/robertmaynard/triangle.git
  URL     "https://www.paraview.org/files/dependencies/triangle-4c20820448cdfa27f968cfd7cb33ea5b9426ad91.tar.bz2"
  URL_MD5 9a016bc90f1cdff441c75ceb53741b11)

superbuild_set_revision(pythonmeshio
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/meshio-4.3.11.tar.gz"
  URL_MD5 56593e77540413ceaccaecccd6b55585)

superbuild_set_revision(pythondiskcache
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/diskcache-3.1.0.tar.gz"
  URL_HASH SHA256=96cd1be1240257167a090794cce45db02ecf39d20b7a062580299b42107690ac)

superbuild_set_revision(pythongirderclient
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/girder-client-2.4.0.tar.gz"
  URL_HASH SHA256=1a9c882b8bce2e8233f572a4df9565c678e5614993e6606cdff04251532cddcb)

superbuild_set_revision(pythonrequests
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/requests-2.26.0.tar.gz"
  URL_MD5 8c745949ad3e9ae83d9927fed213db8a)

superbuild_set_revision(pythonrequeststoolbelt
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/requests-toolbelt-0.8.0.tar.gz"
  URL_HASH SHA256=f6a531936c6fa4c6cfce1b9c10d5c4f498d16528d2a54a22ca00011205a187b5)

superbuild_set_revision(pythoncharsetnormalizer
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/charset-normalizer-2.0.6.tar.gz"
  URL_HASH SHA256=5ec46d183433dcbd0ab716f2d7f29d8dee50505b3fdb40c6b985c7c4f5a3591f)

superbuild_set_revision(pythonidna
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/idna-3.2.tar.gz"
  URL_HASH SHA256=467fbad99067910785144ce333826c71fb0e63a425657295239737f7ecd125f3)

superbuild_set_revision(pythonpysocks
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/PySocks-1.7.1.tar.gz"
  URL_HASH SHA256=3f8804571ebe159c380ac6de37643bb4685970655d3bba243530d6558b799aa0)

superbuild_set_revision(pythonurllib3
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/urllib3-1.26.7.tar.gz"
  URL_HASH SHA256=4987c65554f7a2dbf30c18fd48778ef124af6fab771a377103da0585e2336ece)

superbuild_set_revision(pythoncertifi
  URL      "https://www.computationalmodelbuilder.org/files/dependencies/certifi-2021.10.8.tar.gz"
  URL_HASH SHA256=78884e7c1d4b00ce3cea67b44566851c4343c120abd683433ce934a68ea58872)

superbuild_set_revision(pybind11
  # https://github.com/pybind/pybind11.git
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/pybind11-97784dad3e518ccb415d5db57ff9b933495d9024.tar.bz2"
  URL_MD5 3e20adc18562f482b86bebaed19c55d2)

superbuild_set_revision(ftgl
  # https://github.com/ulrichard/ftgl.git
  URL     "https://www.paraview.org/files/dependencies/ftgl-dfd7c9f0dee7f0059d5784f3a71118ae5c0afff4.tar.bz2"
  URL_MD5 16e54c7391f449c942f3f12378db238f)

superbuild_set_revision(occt
  # https://git.dev.opencascade.org/gitweb/?p=occt.git pick the tag you want, and download a snapshot.
  # current: 7.4.0p1
  # Extract, delete docs, tests, and sample data, and recompress as .tar.bz2
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/occt-7.4.0p1-stripped.tar.bz2"
  URL_MD5 24b95c5d55558ba087b9565f30c67718)

superbuild_set_revision(protobuf
  GIT_REPOSITORY "https://github.com/protocolbuffers/protobuf"
  GIT_TAG         v3.8.0
  SOURCE_SUBDIR   cmake
  GIT_SHALLOW     "ON")

superbuild_set_revision(cmbusersguide
  URL     "https://media.readthedocs.org/pdf/cmb/master/cmb.pdf")

superbuild_set_revision(smtkusersguide
  URL     "https://media.readthedocs.org/pdf/smtk/latest/smtk.pdf")

superbuild_set_revision(aevaexampledata
  URL     "https://data.kitware.com/api/v1/file/6194eb2d2fa25629b9dc75b5/download/aeva-example.zip")

# Use json from Wed Mar 20 21:03:30 2019 +0100
superbuild_set_revision(nlohmannjson
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/json-295732a81780378c62d1c095078b4634dac8ec28.tar.bz2"
  URL_MD5 2113211f84a0b01c1c70900285c81e2c)

superbuild_set_revision(meshkit
  SOURCE_DIR "${CMAKE_CURRENT_LIST_DIR}/meshkit")

superbuild_set_revision(rggsession
  GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/plugins/rgg-session.git"
  GIT_TAG         origin/master
  GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_revision(opencascadesession
  GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/plugins/opencascade-session.git"
  GIT_TAG         origin/master
  GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_revision(smtkresourcemanagerstate
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/read-and-write-resource-manager-state.git"
  GIT_TAG        "origin/master")

superbuild_set_revision(smtktruchasextensions
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/truchas-extensions.git"
  GIT_TAG        "origin/master")

superbuild_set_revision(smtkcmb2dextensions
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/cmb-2d.git"
  GIT_TAG        "origin/master")

superbuild_set_revision(pegtl
  # https://github.com/taocpp/PEGTL/releases/tag/2.7.1
  URL "https://www.computationalmodelbuilder.org/files/dependencies/PEGTL-2.7.1.tar.gz"
  URL_MD5 da0363623cf0936e4cb2648b001af257)

superbuild_set_revision(las
  URL     "https://www.paraview.org/files/dependencies/libLAS-1.8.1.tar.bz2"
  URL_MD5 2e6a975dafdf57f59a385ccb87eb5919)

if (APPLE)
  set(capstone_file "Capstone_MacOsX_V912_Git_37e7ecd9b.dmg")
  set(capstone_md5 d7d64e784864295282e487930b4aafee)
elseif (NOT WIN32)
  set(capstone_file "Capstone_Redhat_7_6_V912_Git_37e7ecd.tar.gz")
  set(capstone_md5 5ecfd45eaa7b9b8109e72aa6fcfc0844)
endif ()

superbuild_set_revision(capstone
  URL "file://${KW_SHARE}/Projects/CMB/dependencies/Capstone-9.1.2/${capstone_file}"
  URL_MD5 "${capstone_md5}")

if (APPLE)
  set(cubit_file "Cubit-15.2-Mac64.dmg")
  set(cubit_md5 2bf9dedc8029b32040f06414ba3b88f9)
elseif (NOT WIN32)
  set(cubit_file "Cubit-15.2-Lin64.tar")
  set(cubit_md5 4f2cb33ac8eae693fdc289bc4ef172f4)
endif ()

superbuild_set_revision(cubit
  URL "file://${KW_SHARE}/Projects/CMB/dependencies/Cubit-15.2/${cubit_file}"
  URL_MD5 "${cubit_md5}")

superbuild_set_selectable_source(aevasession
  SELECT git CUSTOMIZABLE DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/aeva/session.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-aevasession")

superbuild_set_selectable_source(aeva
  SELECT git CUSTOMIZABLE DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/aeva/aeva.git"
    GIT_TAG         "origin/master"
    GIT_SHALLOW     "${SUPERBUILD_SHALLOW_CLONES}"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-aeva")

superbuild_set_revision(netgen
  URL     "https://www.computationalmodelbuilder.org/files/dependencies/netgen-6.2.2105.tar.gz"
  URL_MD5 63cbe3a720c955cc0e00055345db2ec2)

superbuild_set_selectable_source(xmscore
  SELECT superbuild-1.0 DEFAULT
    URL "https://www.computationalmodelbuilder.org/files/dependencies/xmscore-superbuild-v1.0.tar.gz"
    URL_MD5 e2f4fd8a8557b81c0886daa787d7ed27
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY "https://github.com/kwryankrattiger/xmscore.git"
    GIT_TAG kitware_superbuild
    GIT_SHALLOW "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_selectable_source(xmsgrid
  SELECT superbuild-1.0 DEFAULT
    URL "https://www.computationalmodelbuilder.org/files/dependencies/xmsgrid-superbuild-v1.0.tar.gz"
    URL_MD5 148d5291a892d588e2e6fd036127a48c
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY "https://github.com/kwryankrattiger/xmsgrid.git"
    GIT_TAG kitware_superbuild
    GIT_SHALLOW "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_selectable_source(xmsinterp
  SELECT superbuild-1.0 DEFAULT
    URL "https://www.computationalmodelbuilder.org/files/dependencies/xmsinterp-superbuild-v1.0.tar.gz"
    URL_MD5 ffc53012ec1bbdf94d5a7c040e4c778c
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY "https://github.com/kwryankrattiger/xmsinterp.git"
    GIT_TAG kitware_superbuild
    GIT_SHALLOW "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_selectable_source(xmsmesher
  SELECT superbuild-1.0 DEFAULT
    URL "https://www.computationalmodelbuilder.org/files/dependencies/xmsmesher-superbuild-v1.0.tar.gz"
    URL_MD5 195ee695bd180813db05fddc1c6033d8
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY "https://github.com/kwryankrattiger/xmsmesher.git"
    GIT_TAG kitware_superbuild
    GIT_SHALLOW "${SUPERBUILD_SHALLOW_CLONES}")

superbuild_set_revision(smtkxmsmesher
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/xmsmeshoperation.git"
  GIT_TAG "origin/master"
  GIT_SHALLOW "${SUPERBUILD_SHALLOW_CLONES}")
