superbuild_add_project(gdal
  DEPENDS zlib
  DEPENDS_OPTIONAL cxx11
  CMAKE_ARGS
    -DGDAL_USE_CURL:BOOL=OFF
    -DGDAL_USE_LIBJPEG_INTERNAL:BOOL=ON
    -DGDAL_USE_LIBTIFF_INTERNAL:BOOL=ON
    -DGDAL_ENABLE_FRMT_PDF:BOOL=OFF
    -DGDAL_ENABLE_FRMT_VRT:BOOL=ON
    -DOGR_ENABLE_SHP:BOOL=ON
    -DGDAL_ENABLE_FRMT_MEM:BOOL=ON
    -DOGR_ENABLE_MEM:BOOL=ON)

superbuild_apply_patch(gdal no-sqlite
  "Disable sqlite support in GML")
superbuild_apply_patch(gdal lt_objdir-warning
  "Fix warning about LT_OBJDIR redefinition")
superbuild_apply_patch(gdal no-geos
  "Skip GEOS and Armadillo support")
superbuild_apply_patch(gdal pointer-comparison
  "Fix illegal pointer comparisons")

superbuild_add_extra_cmake_args(
  -DGDAL_ROOT:PATH=<INSTALL_DIR>
  -DFindGDAL_SKIP_GDAL_CONFIG:BOOL=ON)
