superbuild_set_revision(boost
  URL     "https://www.paraview.org/files/dependencies/boost_1_66_0.tar.bz2"
  URL_MD5 b2dfbd6c717be4a7bb2d88018eaccf75)

# While the goal is to be consistent with a SHA on ParaView's main fork, CMB
# frequently uses a custom fork of ParaView in order to maintain functionality
# while updating the connections between the two projects. When this happens, it
# is critical that the forked ParaView also push ParaView's tags to the fork,
# since this is how ParaView determines its version (and, resultantly, how it
# names its libraries).
#
# To push ParaView's tags:
#   $ cd <path-to-sb-build-tree>/superbuild/paraview/src
#   $ git remote add kitware https://gitlab.kitware.com/paraview/paraview.git
#   $ git fetch --tags kitware
#   $ git push --tags origin

# XXX: When updating this, update the version number in CMakeLists.txt as well.
#
# The current version of ParaView is version 5.6.0
#
# + commit c1693e068ac618ee16c28bf1ba3a0abfe3a48f90 which fixes the pixmap size for
# Qt 5.12.0.
#
# + commit 5331d6cbf25f5d2e0efaa81a7c59f52eb6af284c which allows derived
# applications to override ParaView's reader factory

# + commit 955abbe176294ed0df83aeeb25dad5e35faea9cf which adds a hint to change
# selection port
#
# + commit c33cbc72c756c4a1cd34cbd82a22ab9f06b39f89 which moves selection
# representation construction to xml
#
# + commit 6a47725bd3c63a906f8898cfe898b5d029c60433 which bumps vtk to include
# glyph mapper fixes
#
# + commit 405375609efa6cae7521d14efccebf041289ee8c which uses a custom VTK for
# CMB
#
# + commit ebcd147714d467fc24bc6182c0daa3a25d20f3d0 which backports a
#   change to allow plugins access to client-side selections before they
#   are simplified, split, and serialized to the server. This is needed
#   for picking glyphed instances (block or cell picks) in SMTK.
#
# + commit d2ca65c363a4329d9c91d295779424b34054d021,
#   commit 6deb5e10c0c908160a251b304f308a171f5616c0, and
#   commit dd24f49e87cd412b4039b70019f7f8bac6481d12 which include
#   further changes to make client-side selections work in SMTK.
#
# These updates are kept on a custom branch on CMB's gitlab group.
#set(paraview_revision "6cccdcfdf885a99009a72468fdfa29dbb696984b")

superbuild_set_selectable_source(paraview
  SELECT git CUSTOMIZABLE DEFAULT
    GIT_REPOSITORY "https://gitlab.kitware.com/cmb/paraview.git"
    GIT_TAG        "2c64f2e43b873a399aa2513a24d336470f2cc3b4"
  SELECT offline
    URL     "http://www.computationalmodelbuilder.org/files/dependencies/paraview-2c64f2e43b873a399aa2513a24d336470f2cc3b4.tar.bz2"
    URL_MD5 33d032ea2f593da8be7c41358627ce10)

superbuild_set_revision(vtkonly
  GIT_REPOSITORY "https://gitlab.kitware.com/vtk/vtk.git"
  GIT_TAG        "v8.2.0")

superbuild_set_selectable_source(cmb
  SELECT 6.3.0 DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "v6.3.0"
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/cmb.git"
    GIT_TAG         "origin/master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-cmb")

superbuild_set_selectable_source(smtk
  SELECT 3.3.0 DEFAULT
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "v3.3.0"
  SELECT git CUSTOMIZABLE
    GIT_REPOSITORY  "https://gitlab.kitware.com/cmb/smtk.git"
    GIT_TAG         "origin/master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-smtk")

superbuild_set_revision(cmbworkflows
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/simulation-workflows.git"
  GIT_TAG        1db37b0cbda0686827e529ed501c876477f4b04f)

superbuild_set_revision(hdf5
  URL     "https://www.paraview.org/files/dependencies/hdf5-1.10.3.tar.bz2"
  URL_MD5 56c5039103c51a40e493b43c504ce982)

superbuild_set_revision(libarchive
  URL https://www.libarchive.org/downloads/libarchive-3.3.3.tar.gz
  URL_MD5 4038e366ca5b659dae3efcc744e72120)

superbuild_set_revision(vxl
# VXL master branch @ May 29, 2018
GIT_REPOSITORY "https://github.com/vxl/vxl"
GIT_TAG 4df45773ea8a74d3560b55a05d5fbb2f76741aac)

# Use opencv from Thu Oct 6 13:40:33 2016 +0000
superbuild_set_revision(opencv
  # https://github.com/opencv/opencv.git
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/opencv-dd379ec9fddc1a1886766cf85844a6e18d38c4f1.tar.bz2"
  URL_MD5 19bbd14ed1bd741beccd6d19e444552f)

# Use the tweaked cmake build of zeromq
superbuild_set_revision(zeromq
  # https://github.com/robertmaynard/zeromq4-x.git
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/zeromq4-6d787cf69da6c69550e85a45be1bee1eb0e1c415.tar.bz2"
  URL_MD5 26790786e01a1732a8acf723b99712ba)

# Use remus from Fri Sep 1 15:56:16 2017 +0000
superbuild_set_revision(remus
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/remus.git"
  GIT_TAG        85355887b0da9d8b81bf1de999ba3a0f3ea7eb80)

superbuild_set_revision(gdal
  # https://github.com/judajake/gdal-svn.git
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/gdal-98353693d6f1d607954220b2f8b040375e3d1744.tar.bz2"
  URL_MD5 5aa285dcc856f98ce44020ae1ae192cb)

superbuild_set_revision(eigen
  # https://github.com/eigenteam/eigen-git-mirror/releases/tag/3.3.7
  URL "http://www.computationalmodelbuilder.org/files/dependencies/eigen-git-mirror-3.3.7.tar.gz"
  URL_MD5 77a2c934eaf35943c43ee600a83b72df)

superbuild_set_revision(moab
  # https://bitbucket.org/fathomteam/moab.git
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/moab-6425a480ffe8e08b96453618fc5530e08e68ae8a.tar.bz2"
  URL_MD5 5946a405cddce972d54044fca6c87b11)

superbuild_set_revision(triangle
  # https://github.com/robertmaynard/triangle.git
  URL     "https://www.paraview.org/files/dependencies/triangle-4c20820448cdfa27f968cfd7cb33ea5b9426ad91.tar.bz2"
  URL_MD5 9a016bc90f1cdff441c75ceb53741b11)

superbuild_set_revision(pythondiskcache
  URL      "https://files.pythonhosted.org/packages/1b/18/ef9b2748bfadc2035d20076869db2dd5d4e22858dd819776bc8f488ec152/diskcache-3.1.0.tar.gz"
  URL_HASH SHA256=96cd1be1240257167a090794cce45db02ecf39d20b7a062580299b42107690ac
)

superbuild_set_revision(pythongirderclient
  URL      "https://files.pythonhosted.org/packages/42/49/a8772bc89b348b0a41e2d583a6aa04d4d9db21a3568a7df17d68029ebb84/girder-client-2.4.0.tar.gz"
  URL_HASH SHA256=1a9c882b8bce2e8233f572a4df9565c678e5614993e6606cdff04251532cddcb
)

superbuild_set_revision(pythonrequests
  URL     "https://pypi.python.org/packages/source/r/requests/requests-2.9.1.tar.gz"
  URL_MD5 0b7f480d19012ec52bab78292efd976d)

superbuild_set_revision(pythonrequeststoolbelt
  URL      "https://files.pythonhosted.org/packages/86/f9/e80fa23edca6c554f1994040064760c12b51daff54b55f9e379e899cd3d4/requests-toolbelt-0.8.0.tar.gz"
  URL_HASH SHA256=f6a531936c6fa4c6cfce1b9c10d5c4f498d16528d2a54a22ca00011205a187b5
)

superbuild_set_revision(pybind11
  # https://github.com/pybind/pybind11.git
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/pybind11-97784dad3e518ccb415d5db57ff9b933495d9024.tar.bz2"
  URL_MD5 3e20adc18562f482b86bebaed19c55d2)

superbuild_set_revision(ftgl
  # https://github.com/ulrichard/ftgl.git
  URL     "https://www.paraview.org/files/dependencies/ftgl-dfd7c9f0dee7f0059d5784f3a71118ae5c0afff4.tar.bz2"
  URL_MD5 16e54c7391f449c942f3f12378db238f)

superbuild_set_revision(occt
  URL     "https://data.kitware.com/api/v1/item/5bb77c898d777f06b9143195/download"
  URL_MD5 c6774a9019dee19330284eea33370ee7)

superbuild_set_revision(paraviewwebvisualizer
  URL     "https://www.paraview.org/files/dependencies/visualizer-2.0.12.tar.gz"
  URL_MD5 56e7e241ea6ad66b44469fc3186f47d6)

superbuild_set_revision(paraviewweblightviz
  URL     "https://www.paraview.org/files/dependencies/light-viz-1.16.1.tar.gz"
  URL_MD5 9ac1937cf07ae57bf85c3240f921679a)

superbuild_set_revision(protobuf
  GIT_REPOSITORY "https://github.com/protocolbuffers/protobuf"
  GIT_TAG 2.7.0
  SOURCE_SUBDIR cmake)

superbuild_set_revision(pyarc
  GIT_REPOSITORY "git@kwgitlab.kitware.com:bob.obara/PyARC.git"
  GIT_TAG        reorganization)

superbuild_set_revision(cmbusersguide
  URL     "https://media.readthedocs.org/pdf/cmb/master/cmb.pdf")

superbuild_set_revision(smtkusersguide
  URL     "https://media.readthedocs.org/pdf/smtk/latest/smtk.pdf")

# Use json from Wed Mar 20 21:03:30 2019 +0100
superbuild_set_revision(nlohmannjson
  URL     "http://www.computationalmodelbuilder.org/files/dependencies/json-295732a81780378c62d1c095078b4634dac8ec28.tar.bz2"
  URL_MD5 2113211f84a0b01c1c70900285c81e2c)

superbuild_set_revision(meshkit
  SOURCE_DIR "${CMAKE_CURRENT_LIST_DIR}/meshkit")

superbuild_set_revision(rggsession
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/rgg-session"
  GIT_TAG        master)

superbuild_set_revision(smtkresourcemanagerstate
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/read-and-write-resource-manager-state.git"
  GIT_TAG        8ed4ec2c0f759bd6ba699eba78dd0fc773ef8d7f)

superbuild_set_revision(smtkprojectmanager
  GIT_REPOSITORY "https://gitlab.kitware.com/cmb/plugins/project-manager.git"
  GIT_TAG        c18164fc94083f61451139f80a9f26825ec91518)

superbuild_set_revision(pegtl
  # https://github.com/taocpp/PEGTL/releases/tag/2.7.1
  URL "http://www.computationalmodelbuilder.org/files/dependencies/PEGTL-2.7.1.tar.gz"
  URL_MD5 da0363623cf0936e4cb2648b001af257)

if (APPLE)
  set(capstone_file "Capstone_MacOsX_V912_Git_37e7ecd9b.dmg")
  set(capstone_md5 d7d64e784864295282e487930b4aafee)
elseif (NOT WIN32)
  set(capstone_file "Capstone_Redhat_7_6_V912_Git_37e7ecd.tar.gz")
  set(capstone_md5 5ecfd45eaa7b9b8109e72aa6fcfc0844)
endif ()

superbuild_set_revision(capstone
  URL "file://${KW_SHARE}/Projects/CMB/dependencies/Capstone-9.1.2/${capstone_file}"
  URL_MD5 "${capstone_md5}")

if (APPLE)
  set(cubit_file "Cubit-15.2-Mac64.dmg")
  set(cubit_md5 2bf9dedc8029b32040f06414ba3b88f9)
elseif (NOT WIN32)
  set(cubit_file "Cubit-15.2-Lin64.tar")
  set(cubit_md5 4f2cb33ac8eae693fdc289bc4ef172f4)
endif ()

superbuild_set_revision(cubit
  URL "file://${KW_SHARE}/Projects/CMB/dependencies/Cubit-15.2/${cubit_file}"
  URL_MD5 "${cubit_md5}")
