/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile$
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


  Copyright (c) 2000 National Library of Medicine
  All rights reserved.

  See COPYRIGHT.txt for copyright details.

=========================================================================*/
/**
 * cmWindowsConfigure : a class that configures the build
 * on windows where autoconf configure can not be used.
 * The system specific .h files normal generated by autoconf
 * should be generated by sub-classes of this class.
 */
#ifndef cmWindowsConfigure_h
#define cmWindowsConfigure_h
#include <string>

class cmWindowsConfigure
{
public:
  /**
   * Set the path to the top level of the source directory
   */
  void SetWhereSource(const char* dir) 
    {
      m_WhereSource = dir;
    }
  /**
   * Set the path to the top level of the build directory
   */
  void SetWhereBuild(const char* dir)
    {
      m_WhereBuild = dir;
    }
  virtual bool Configure(const char* input);
protected:
  std::string m_WhereSource;
  std::string m_WhereBuild;
};

#endif
