/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.glassfish.jersey.server.internal.AbstractResourceFinderAdapter;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderException;
import org.glassfish.jersey.server.internal.scanning.UriSchemeResourceFinderFactory;

class BundleSchemeResourceFinderFactory
implements UriSchemeResourceFinderFactory {
    @Override
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("bundle"));
    }

    BundleSchemeResourceFinderFactory() {
    }

    @Override
    public BundleSchemeScanner create(URI uri, boolean recursive) {
        return new BundleSchemeScanner(uri);
    }

    private class BundleSchemeScanner
    extends AbstractResourceFinderAdapter {
        private URI uri;
        private boolean accessed = false;
        private boolean iterated = false;

        private BundleSchemeScanner(URI uri) {
            this.uri = uri;
        }

        @Override
        public boolean hasNext() {
            return !this.accessed && !this.iterated;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                this.iterated = true;
                return this.uri.getPath();
            }
            throw new NoSuchElementException();
        }

        @Override
        public InputStream open() {
            if (!this.accessed) {
                try {
                    this.accessed = true;
                    return this.uri.toURL().openStream();
                }
                catch (IOException e) {
                    throw new ResourceFinderException(e);
                }
            }
            return null;
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

