/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;
import org.j3d.renderer.java3d.overlay.Overlay;
import org.j3d.renderer.java3d.overlay.UpdateManager;

public class TextureOverlay
implements Overlay,
ComponentListener {
    private static final double CONSOLE_Z = (double)2.1f;
    private static final float[] TEXTURE_COORDS = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    protected static final int DIRTY_VISIBLE = 0;
    protected static final int DIRTY_POSITION = 1;
    protected static final int DIRTY_ACTIVE_BUFFER = 2;
    protected static final int DIRTY_SIZE = 3;
    private int backgroundMode = 1;
    private boolean visible;
    private boolean antialiased;
    private Rectangle overlayBounds;
    private Dimension componentSize;
    private double fieldOfView;
    private UpdateManager updateManager;
    private Canvas3D canvas3D;
    protected BranchGroup consoleBG;
    private TransformGroup consoleTG;
    private Appearance appearance;
    private QuadArray geometry;
    private RenderingAttributes renderAttributes;
    private TransparencyAttributes transAttr;
    private int transMode;
    private boolean fixedSize;
    private boolean painting = false;
    private boolean initComplete;
    private boolean[] dirtyCheck = new boolean[4];

    public TextureOverlay(Canvas3D canvas3D, Dimension dimension) {
        this(canvas3D, dimension, true, null, null);
    }

    public TextureOverlay(Canvas3D canvas3D, Dimension dimension, Texture2D texture2D) {
        this(canvas3D, dimension, true, null, texture2D);
    }

    public TextureOverlay(Canvas3D canvas3D, Dimension dimension, boolean bl, UpdateManager updateManager, Texture2D texture2D) {
        View view;
        if (canvas3D == null && dimension == null) {
            throw new IllegalArgumentException("Both canvas and size null");
        }
        this.initComplete = false;
        this.canvas3D = canvas3D;
        if (dimension == null) {
            this.overlayBounds = canvas3D.getBounds();
            this.componentSize = canvas3D.getSize();
            view = canvas3D.getView();
            this.fieldOfView = view == null ? 0.785398 : view.getFieldOfView();
            this.fixedSize = false;
        } else {
            this.overlayBounds = new Rectangle(0, 0, dimension.width, dimension.height);
            this.fixedSize = true;
            if (this.canvas3D != null) {
                this.componentSize = canvas3D.getSize();
                view = canvas3D.getView();
                this.fieldOfView = view == null ? 0.785398 : view.getFieldOfView();
            } else {
                this.componentSize = new Dimension(dimension);
                this.fieldOfView = 0.785398;
            }
        }
        this.visible = true;
        this.antialiased = true;
        if (!this.fixedSize || this.canvas3D != null) {
            this.canvas3D.addComponentListener((ComponentListener)this);
        }
        this.consoleBG = new BranchGroup();
        this.consoleBG.setCapability(17);
        this.consoleTG = new TransformGroup();
        this.consoleTG.setCapability(18);
        this.consoleBG.addChild((Node)this.consoleTG);
        this.updateManager = updateManager;
        this.renderAttributes = new RenderingAttributes();
        this.renderAttributes.setDepthBufferEnable(false);
        this.renderAttributes.setDepthBufferWriteEnable(true);
        this.renderAttributes.setIgnoreVertexColors(true);
        this.renderAttributes.setCapability(5);
        this.renderAttributes.setCapability(6);
        view = new PolygonAttributes();
        view.setBackFaceNormalFlip(false);
        view.setCullFace(0);
        view.setPolygonMode(2);
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(5);
        textureAttributes.setPerspectiveCorrectionMode(0);
        textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 1.0f));
        this.transMode = texture2D != null ? (texture2D.getFormat() == 6 ? 2 : 4) : (bl ? 2 : 4);
        this.transAttr = new TransparencyAttributes(this.transMode, 1.0f);
        this.transAttr.setCapability(1);
        this.appearance = new Appearance();
        this.appearance.setCapability(3);
        this.appearance.setPolygonAttributes((PolygonAttributes)view);
        this.appearance.setRenderingAttributes(this.renderAttributes);
        this.appearance.setTextureAttributes(textureAttributes);
        this.appearance.setTransparencyAttributes(this.transAttr);
        if (texture2D != null) {
            this.appearance.setTexture((Texture)texture2D);
        }
        Material material = new Material();
        material.setLightingEnable(false);
        this.appearance.setMaterial(material);
        int n = 33;
        this.geometry = new QuadArray(4, n);
        this.geometry.setCapability(1);
        float[] fArray = new float[]{this.overlayBounds.width, 0.0f, 0.0f, this.overlayBounds.width, this.overlayBounds.height, 0.0f, 0.0f, this.overlayBounds.height, 0.0f, 0.0f, 0.0f, 0.0f};
        this.geometry.setCoordinates(0, fArray);
        this.geometry.setTextureCoordinates(0, 0, TEXTURE_COORDS);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(this.appearance);
        shape3D.setGeometry((Geometry)this.geometry);
        this.consoleTG.addChild((Node)shape3D);
        this.dirtyCheck[0] = true;
        this.dirtyCheck[1] = true;
    }

    public void initialize() {
        this.initComplete = true;
    }

    public BranchGroup getRoot() {
        return this.consoleBG;
    }

    public Rectangle getBounds() {
        return this.overlayBounds;
    }

    public boolean contains(Point point) {
        return this.overlayBounds.contains(point);
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    public void setLocation(int n, int n2) {
        if (this.overlayBounds.x != n || this.overlayBounds.y != n2) {
            this.overlayBounds.x = n;
            this.overlayBounds.y = n2;
            this.dirty(1);
        }
    }

    public void setSize(int n, int n2) {
        if (this.overlayBounds.width != n || this.overlayBounds.height != n2) {
            this.overlayBounds.width = n;
            this.overlayBounds.height = n2;
            this.dirty(3);
        }
    }

    public void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty(0);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setComponentDetails(Dimension dimension, double d) {
        this.componentSize = dimension;
        this.fieldOfView = d;
        if (this.fixedSize) {
            this.dirty(1);
        } else {
            this.dirty(3);
        }
    }

    public void update() {
        if (this.dirtyCheck[3]) {
            this.syncSize();
        }
        if (this.dirtyCheck[1]) {
            this.syncPosition();
        }
        if (this.dirtyCheck[0]) {
            this.syncVisible();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.canvas3D != null) {
            this.componentSize = this.canvas3D.getSize();
            View view = this.canvas3D.getView();
            if (view != null) {
                this.fieldOfView = view.getFieldOfView();
            }
        }
        if (this.fixedSize) {
            this.dirty(1);
        } else {
            this.dirty(3);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.dirty(1);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void setTexture(Texture2D texture2D) {
        this.appearance.setTexture((Texture)texture2D);
        int n = texture2D.getFormat();
        int n2 = 2;
        if (n == 5) {
            n2 = 4;
        }
        if (n2 != this.transMode) {
            this.transMode = n2;
            this.transAttr.setTransparencyMode(n2);
        }
    }

    private void dirty(int n) {
        if (!this.initComplete) {
            return;
        }
        this.dirtyCheck[n] = true;
        if (this.updateManager != null) {
            this.updateManager.updateRequested(this);
        }
    }

    private void syncVisible() {
        this.renderAttributes.setVisible(this.visible);
        this.dirtyCheck[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPosition() {
        Rectangle rectangle = this.overlayBounds;
        synchronized (rectangle) {
            if (this.componentSize.width == 0 || this.componentSize.height == 0 || this.overlayBounds.height == 0 || this.overlayBounds.width == 0) {
                return;
            }
            double d = (double)4.2f * Math.tan(this.fieldOfView * 0.5);
            double d2 = d / (double)this.componentSize.width;
            double d3 = (double)this.componentSize.height * d2;
            float f = this.overlayBounds.x;
            float f2 = this.componentSize.height - this.overlayBounds.height - this.overlayBounds.y;
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d(-d / 2.0 + (double)f * d2, -d3 / 2.0 + (double)f2 * d2, -2.1f);
            transform3D.setTranslation(vector3d);
            transform3D.setScale(d2);
            this.consoleTG.setTransform(transform3D);
            this.dirtyCheck[1] = false;
        }
    }

    private void syncSize() {
        if (!this.fixedSize) {
            this.overlayBounds = this.canvas3D.getBounds();
        }
        if (this.overlayBounds.width != 0 && this.overlayBounds.height != 0) {
            if (this.visible) {
                this.renderAttributes.setVisible(true);
            }
            float[] fArray = new float[]{this.overlayBounds.width, 0.0f, 0.0f, this.overlayBounds.width, this.overlayBounds.height, 0.0f, 0.0f, this.overlayBounds.height, 0.0f, 0.0f, 0.0f, 0.0f};
            this.geometry.setCoordinates(0, fArray);
        } else {
            this.renderAttributes.setVisible(false);
        }
        this.dirtyCheck[3] = false;
        this.syncPosition();
    }
}

