/*=========================================================================

  Program:   ParaView
  Module:    vtkPVTimerLogDisplay.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkPVTimerLogDisplay - Shows a text version of the timer log entries.
// .SECTION Description
// A widget to display timing information in the timer log.

#ifndef __vtkPVTimerLogDisplay_h
#define __vtkPVTimerLogDisplay_h

#include "vtkKWWidget.h"
class vtkKWApplication;
class vtkPVApplication;
class vtkKWPushButton;
class vtkKWEntry;
class vtkKWLabel;
class vtkKWText;
class vtkKWWindow;
class vtkKWOptionMenu;
class vtkKWCheckButton;
class vtkPVTimerInformation;

class VTK_EXPORT vtkPVTimerLogDisplay : public vtkKWWidget
{
public:
  static vtkPVTimerLogDisplay* New();
  vtkTypeRevisionMacro(vtkPVTimerLogDisplay, vtkKWWidget);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Create a Tk widget
  virtual void Create(vtkKWApplication *app);
  
  // Description:
  // Display the interactor
  void Display();

  // Description:
  // Callback from the dismiss button that closes the window.
  void Dismiss();

  // Description:
  // Set the title of the TclInteractor to appear in the titlebar
  vtkSetStringMacro(Title);
  
  // Description:
  // Set the window to which the dialog will be slave.
  // If set, this dialog will always be on top of the master
  // window and will minimize with it (assuming that the windowing
  // system supports this)
  void SetMasterWindow(vtkKWWindow* win);
  
  // Description:
  // This threshold eliminates the shosrt duration events fro the display.
  void SetThreshold(float val);
  vtkGetMacro(Threshold, float);

  // Description:
  // Control the maximum length of the timer log buffer.
  void SetBufferLength(int len);
  int GetBufferLength();

  // Description:
  // Saves the current log to a file.
  void Save();
  virtual void Save(const char* fileName);

  // Description:
  // Clear all entries from the buffer.
  virtual void Clear();

  // Description:
  // Call back from the EnableCheck that will stop or start loging of events.
  void EnableCheckCallback();

  vtkPVTimerInformation* GetTimerInformation();

  // Description:
  // A convience method to cast KWApplication to PVApplication.
  vtkPVApplication* GetPVApplication();

protected:
  vtkPVTimerLogDisplay();
  ~vtkPVTimerLogDisplay();

  virtual void Update();
  void DisplayLog();

  // Description:
  // Open log for writing.
  void EnableWrite();

  // Description:
  // Close log for writing
  void DisableWrite();

  void Append(const char*);
  
  vtkKWWindow*      MasterWindow;

  vtkKWWidget*      ControlFrame;
  vtkKWPushButton*  SaveButton;
  vtkKWPushButton*  ClearButton;
  vtkKWLabel*       ThresholdLabel;
  vtkKWOptionMenu*  ThresholdMenu;
  vtkKWLabel*       BufferLengthLabel;
  vtkKWOptionMenu*  BufferLengthMenu;
  vtkKWLabel*       EnableLabel;
  vtkKWCheckButton* EnableCheck;

  vtkKWWidget*      DisplayFrame;
  vtkKWText*        DisplayText;
  vtkKWWidget*      DisplayScrollBar;

  vtkKWWidget*     ButtonFrame;
  vtkKWPushButton* DismissButton;
    
  char*   Title;
  float   Threshold;
  int     Writable;

  vtkPVTimerInformation* TimerInformation;

private:
  vtkPVTimerLogDisplay(const vtkPVTimerLogDisplay&); // Not implemented
  void operator=(const vtkPVTimerLogDisplay&); // Not implemented
};

#endif
