/*=========================================================================

  Program:   ParaView
  Module:    vtkPVClipPlane.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Copyright (c) 2000-2001 Kitware Inc. 469 Clifton Corporate Parkway,
Clifton Park, NY, 12065, USA.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name of Kitware nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific 
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
// .NAME vtkPVClipPlane - A class to handle the special case of cutting
// with an implict plane
// .SECTION Description


#ifndef __vtkPVClipPlane_h
#define __vtkPVClipPlane_h

#include "vtkPVSource.h"
class vtkKWBoundsDisplay;

class VTK_EXPORT vtkPVClipPlane : public vtkPVSource
{
public:
  static vtkPVClipPlane* New();
  vtkTypeMacro(vtkPVClipPlane, vtkPVSource);
    
  void CreateProperties();

  // Description:
  // Callback that set the center to the middle of the bounds.
  void CenterResetCallback();

  // Descript:
  // Callbacks to set the normal.
  void NormalCameraCallback();
  void NormalXCallback();
  void NormalYCallback();
  void NormalZCallback();

  // Description:
  // Also Update the bounds display.
  virtual void UpdateParameterWidgets();
    
  // Description:
  // Called when Accept is presed.
  // Needed to get around a Tcl problem.
  virtual void AcceptCallback();

protected:
  vtkPVClipPlane();
  ~vtkPVClipPlane();
  vtkPVClipPlane(const vtkPVClipPlane&) {};
  void operator=(const vtkPVClipPlane&) {};

  vtkKWBoundsDisplay *BoundsDisplay;

  vtkKWWidget *CenterFrame;
  vtkKWLabel *CenterLabel;
  vtkKWEntry *CenterXEntry;
  vtkKWEntry *CenterYEntry; 
  vtkKWEntry *CenterZEntry;
  vtkKWPushButton *CenterResetButton;

  vtkKWWidget *NormalFrame;
  vtkKWLabel *NormalLabel;
  vtkKWEntry *NormalXEntry;
  vtkKWEntry *NormalYEntry; 
  vtkKWEntry *NormalZEntry;

  vtkKWWidget *NormalButtonFrame;
  vtkKWPushButton *NormalCameraButton;
  vtkKWPushButton *NormalXButton;
  vtkKWPushButton *NormalYButton;
  vtkKWPushButton *NormalZButton;

  vtkKWWidget *OffsetFrame;
  vtkKWLabel *OffsetLabel;
  vtkKWEntry *OffsetEntry;

};

#endif
