Catalyst 2.0 Release Notes
==========================

* [Release Features](#release-features)
* [New Language Bindings](#new-language-bindings)
* [Conduit API Improvements](#included-conduit-api-improvements)

This is the first release of the Catalyst API as a standalone project. Catalyst
is an API developed for simulations to communicate in situ with analysis and
visualization tools

See [the documentation][catalyst-docs] for development and usage instructions.

[catalyst-docs]: https://catalyst-in-situ.readthedocs.io/en/latest/index.html

# Release Features

## New Conduit Version

Update to conduit 0.8.7 internally. This brings in a few more APIs:

- `conduit_datatype_sizeof_index_t`
- `conduit_node_move`
- `conduit_node_reset`
- `conduit_node_swap`


## External Conduit Support

An external Conduit is now supported via the `CATALYST_WITH_EXTERNAL_CONDUIT`
CMake option. Additionally, there is a `CATALYST_RELOCATABLE_INSTALL` option to
support embedding the build-time Conduit path into the install tree to ease
usage of the package at the cost of not being able to be moved to any other
path reliably.

Note that at least Conduit 0.8.6 is required to provide all of the symbols
required.

## Conduit Implementation Improvements

The state of Catalysts's Conduit being provided by Catalyst or by an external
build is now part of the implementation structure. Implementations built
against a Catalyst with a different state of Conduit are not compatible with
each other. The new `catalyst_status_error_conduit_mismatch` status is returned
if a Conduit mismatch is detected.

## Conduit Imported Targets

Catalyst no longer exposes the internal Conduit targets used to manage its
vendored copy to exports. This requires CMake 3.26 in order to work properly.


## Pass Conduit Nodes to Python

The function `PyCatalystConduit_Node_Wrap` can now be used to pass a
`conduit_node` from C/C++ to Python via the CPython interface.  If catalyst is
built without Python wrappings the function will just return `nullptr`.

# New Language Bindings

## Python bindings

The Catalyst API is now wrapped in Python.
This makes available the Python bindings of conduit.
All functions live under the `catalyst` Python module.
Input parameters can be created using conduit's Python API. To compile the Python interface, use `CATALYST_WRAP_PYTHON=ON` when compiling Catalyst.

## Fortran bindings

The Catalyst API is wrapped in Fortran. Simulation developers can
now access Catalyst in Fortran. To compile the Fortran interface
use `CATALYST_WRAP_FORTRAN=ON` when compiling Catalyst.

# Included Conduit API Improvements

## Added `Node::number_of_elements` Method

The `conduit_cpp::Node::number_of_elements` method was missing and is now
available.

## Mangled Conduit Functions Improvements

The `conduit_node_fetch_node_data_ptr` function had been improperly mangled as
`catalyst_conduit_node_fetch_path_data_ptr`. The function is now properly
mangled and the improper mangled name is provieded for compatibility with older
Catalyst versions.
