# ParaView Async Examples

This repository contains trame-based applications driven by an asynchronous paraview backend.
Refer to the [Async/ParaView](https://gitlab.kitware.com/async/paraview) project for source code.
In order to compare the responsiveness and performance, we also provide apps that use the paraview synchronous backend.

## Async backend
### NVIDIA EGL rendering
You may need to setup `nvidia-docker2`. Follow instructions outlined [here](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/install-guide.html).

#### Build
```shell
$ ./async/docker/nvidia/build-all.sh
```

#### Run
Please click on the link with ip=`127.0.0.1`

```shell
$ ./async/docker/nvidia/run-docker.sh rock.py 8080
2022-11-03 12:13:31.980 (   0.051s) [Parat           ]  vtkServicesEngine.cxx:145   INFO| vtkThalliumServicesEngine (0x556a2731a290): initializing session (sockets://)
ParaView is using venv: /opt/paraview-async/runtime/.pvenv

App running at:
 - Local:   http://127.0.0.1:8080/
 - Network: http://127.0.1.1:8080/

Note that for multi-users you need to use and configure a launcher.
```

### OSMesa software rendering

#### Build
```shell
$ ./async/docker/osmesa/build-all.sh
```

#### Run
Please click on the link with ip=`127.0.0.1`

```shell
$ ./async/docker/osmesa/run-docker.sh rock.py 8080
2022-11-03 12:13:31.980 (   0.051s) [Parat           ]  vtkServicesEngine.cxx:145   INFO| vtkThalliumServicesEngine (0x556a2731a290): initializing session (sockets://)
ParaView is using venv: /opt/paraview-async/runtime/.pvenv

App running at:
 - Local:   http://127.0.0.1:8080/
 - Network: http://127.0.1.1:8080/

Note that for multi-users you need to use and configure a launcher.
```

## Sync backend
### NVIDIA EGL rendering
You may need to setup `nvidia-docker2`. Follow instructions outlined [here](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/install-guide.html).

#### Build
```shell
$ ./sync/docker/nvidia/build.sh
```

#### Run
Please click on the link with ip=`127.0.0.1`

```shell
$ ./sync/docker/nvidia/run-docker.sh rock.py 8080
Ignoring PCI device with non-16bit domain.
Pass --enable-32bits-pci-domain to configure to support such devices
(warning: it would break the library ABI, don't enable unless really needed).
ParaView is using venv: /opt/paraview/runtime/.pvenv
Server ready

App running at:
 - Local:   http://127.0.0.1:8080/
 - Network: http://127.0.1.1:8080/

Note that for multi-users you need to use and configure a launcher.
```

### OSMesa software rendering

#### Build
```shell
$ ./sync/docker/osmesa/build.sh
```

#### Run
Please click on the link with ip=`127.0.0.1`

```shell
$ ./sync/docker/osmesa/run-docker.sh rock.py 8080
Ignoring PCI device with non-16bit domain.
Pass --enable-32bits-pci-domain to configure to support such devices
(warning: it would break the library ABI, don't enable unless really needed).
ParaView is using venv: /opt/paraview/runtime/.pvenv
Server ready

App running at:
 - Local:   http://127.0.0.1:8080/
 - Network: http://127.0.1.1:8080/

Note that for multi-users you need to use and configure a launcher.
```

## Tips
When running multiple containers, try to use different port numbers, 8080, 8081, etc.
