/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestJobServerClient.h"

#include <utility>

#include <cm/memory>
#include <cm/optional>

#if defined(_WIN32)
#  include "cmCTestJobServerWindows.h"
#else
#  include "cmCTestJobServerPosix.h"
#endif

cm::optional<std::unique_ptr<cmCTestJobServerClient>>
cmCTestJobServerClient::Connect(uv_loop_t* loop, size_t maxJobs)
{
#if defined(_WIN32)
  std::unique_ptr<cmCTestJobServerWindows> client =
    cm::make_unique<cmCTestJobServerWindows>(maxJobs);
  if (client->Connect(loop)) {
    return cm::optional<std::unique_ptr<cmCTestJobServerClient>>(
      std::move(client));
  }
#else
  std::unique_ptr<cmCTestJobServerPosix> client =
    cm::make_unique<cmCTestJobServerPosix>(maxJobs);
  if (client->Connect(loop)) {
    return cm::optional<std::unique_ptr<cmCTestJobServerClient>>(
      std::move(client));
  }
#endif
  return cm::nullopt;
}
