/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestJobServerClient.h"

#include <utility>

#include <cm/memory>
#include <cm/optional>

#include "cmCTestJobServerPosix.h"

cm::optional<std::unique_ptr<cmCTestJobServerClient>>
cmCTestJobServerClient::Connect(uv_loop_t* loop, size_t maxJobs)
{
#if defined(_WIN32)
  return cm::nullopt;
#else
  std::unique_ptr<cmCTestJobServerPosix> client =
    cm::make_unique<cmCTestJobServerPosix>(maxJobs);
  if (client->Connect(loop)) {
    return cm::optional<std::unique_ptr<cmCTestJobServerClient>>(
      std::move(client));
  }
#endif
  return cm::nullopt;
}
