//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_io_ModelToMesh_h
#define smtk_io_ModelToMesh_h

#include "smtk/CoreExports.h" // For SMTKCORE_EXPORT macro.
#include "smtk/PublicPointerDefs.h"

namespace smtk
{
namespace model
{
class Model;
}

namespace io
{
class SMTKCORE_EXPORT ModelToMesh
{
public:
  //By default will merge duplicate elements, and will use the default tolerance
  //specified by mergeCoincidentContactPoints
  ModelToMesh();

  //By default will merge duplicate elements
  bool isMergingEnabled() const { return m_mergeDuplicates; }
  void setIsMerging(bool m) { m_mergeDuplicates = m; }

  //Allow you to specify a custom tolerance for the merging of duplicate elements
  double getMergeTolerance() const { return m_tolerance; }
  void setMergeTolerance(double tol) { m_tolerance = tol; }

  //convert smtk::model::resource to a smtk::mesh::resource
  smtk::mesh::ResourcePtr operator()(const smtk::model::ResourcePtr& modelResource) const;
  //convert smtk::model to a smtk::mesh::resource
  smtk::mesh::ResourcePtr operator()(const smtk::model::Model& model) const;

private:
  bool m_mergeDuplicates{ true };
  double m_tolerance{ -1 };
};
} // namespace io
} // namespace smtk

#endif
