/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkParseJava.c
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "vtkParse.h"

int numberOfWrappedFunctions = 0;
FunctionInfo *wrappedFunctions[1000];
extern FunctionInfo *currentFunction;

void output_temp(FILE *fp,int i)
{
  /* ignore void */
  if (((currentFunction->ArgTypes[i] % 10) == 2)&&
      (!((currentFunction->ArgTypes[i]%1000)/100)))
    {
    return;
    }
  
  if (currentFunction->ArgTypes[i] == 5000)
    {
    fprintf(fp,"Object id0, String id1");  
    return;
    }
  
  if (currentFunction->ArgTypes[i]%1000 == 303)
    {
    fprintf(fp,"String ");
    }
  else
    {
    switch (currentFunction->ArgTypes[i]%10)
      {
      case 1:   fprintf(fp,"double "); break;
      case 7:   fprintf(fp,"double "); break;
      case 4:   fprintf(fp,"int "); break;
      case 5:   fprintf(fp,"int "); break;
      case 6:   fprintf(fp,"int "); break;
      case 2:     fprintf(fp,"void "); break;
      case 3:     fprintf(fp,"char "); break;
      case 9:     fprintf(fp,"%s ",currentFunction->ArgClasses[i]); break;
      case 8: return;
      }
    }

  fprintf(fp,"id%i",i);
  if (((currentFunction->ArgTypes[i]%1000)/100 == 3)&&
      (currentFunction->ArgTypes[i]%1000 != 303)&&
      (currentFunction->ArgTypes[i]%1000 != 309))
    {
    fprintf(fp,"[]");
    }
}

void return_result(FILE *fp)
{
  switch (currentFunction->ReturnType%1000)
    {
    case 1: fprintf(fp,"double "); break;
    case 2: fprintf(fp,"void "); break;
    case 3: fprintf(fp,"char "); break;
    case 7: fprintf(fp,"double "); break;
    case 4: case 5: case 6: case 13: case 14: case 15: case 16:
      fprintf(fp,"int "); 
      break;
    case 303: fprintf(fp,"String "); break;
    case 109:  
    case 309:  
      fprintf(fp,"%s ",currentFunction->ReturnClass);
      break;
      
      /* handle functions returning vectors */
      /* this is done by looking them up in a hint file */
    case 301: case 307:
      fprintf(fp,"double[] "); 
      break;
    case 313:
        fprintf(fp,"byte[] ");
        break;
    case 304: case 305: case 306: case 314: case 315: case 316:
      fprintf(fp,"int[]  "); break;
    }
}

/* have we done one of these yet */
int DoneOne()
{
  int i,j;
  int match;
  FunctionInfo *fi;
  
  for (i = 0; i < numberOfWrappedFunctions; i++)
    {
    fi = wrappedFunctions[i];
    if ((!strcmp(fi->Name,currentFunction->Name))
        &&(fi->NumberOfArguments == currentFunction->NumberOfArguments))
      {
      match = 1;
      for (j = 0; j < fi->NumberOfArguments; j++)
        {
        if ((fi->ArgTypes[j] != currentFunction->ArgTypes[j]) &&
            !(((fi->ArgTypes[j]%1000 == 309)&&
               (currentFunction->ArgTypes[j]%1000 == 109)) ||
              ((fi->ArgTypes[j]%1000 == 109)&&
               (currentFunction->ArgTypes[j]%1000 == 309)) ||
              ((fi->ArgTypes[j]%1000 == 301)&&
               (currentFunction->ArgTypes[j]%1000 == 307)) ||
              ((fi->ArgTypes[j]%1000 == 307)&&
               (currentFunction->ArgTypes[j]%1000 == 301)) ||
              ((fi->ArgTypes[j]%1000 == 304)&&
               (currentFunction->ArgTypes[j]%1000 == 306)) ||
              ((fi->ArgTypes[j]%1000 == 306)&&
               (currentFunction->ArgTypes[j]%1000 == 304)) ||
              ((fi->ArgTypes[j]%1000 == 1)&&
               (currentFunction->ArgTypes[j]%1000 == 7)) ||
              ((fi->ArgTypes[j]%1000 == 7)&&
               (currentFunction->ArgTypes[j]%1000 == 1)) ||
              ((fi->ArgTypes[j]%1000 == 4)&&
               (currentFunction->ArgTypes[j]%1000 == 6)) ||
              ((fi->ArgTypes[j]%1000 == 6)&&
               (currentFunction->ArgTypes[j]%1000 == 4))))
          {
          match = 0;
          }
        else
          {
          if (fi->ArgTypes[j]%1000 == 309 || fi->ArgTypes[j]%1000 == 109)
            {
            if (strcmp(fi->ArgClasses[j],currentFunction->ArgClasses[j]))
              {
              match = 0;
              }
            }
          }
        }
      if ((fi->ReturnType != currentFunction->ReturnType) &&
          !(((fi->ReturnType%1000 == 309)&&
             (currentFunction->ReturnType%1000 == 109)) ||
            ((fi->ReturnType%1000 == 109)&&
             (currentFunction->ReturnType%1000 == 309)) ||
            ((fi->ReturnType%1000 == 301)&&
             (currentFunction->ReturnType%1000 == 307)) ||
            ((fi->ReturnType%1000 == 307)&&
             (currentFunction->ReturnType%1000 == 301)) ||
            ((fi->ReturnType%1000 == 304)&&
             (currentFunction->ReturnType%1000 == 306)) ||
            ((fi->ReturnType%1000 == 306)&&
             (currentFunction->ReturnType%1000 == 304)) ||
            ((fi->ReturnType%1000 == 1)&&
             (currentFunction->ReturnType%1000 == 7)) ||
            ((fi->ReturnType%1000 == 7)&&
             (currentFunction->ReturnType%1000 == 1)) ||
            ((fi->ReturnType%1000 == 4)&&
             (currentFunction->ReturnType%1000 == 6)) ||
            ((fi->ReturnType%1000 == 6)&&
             (currentFunction->ReturnType%1000 == 4))))
        {
        match = 0;
        }
      else
        {
        if (fi->ReturnType%1000 == 309 || fi->ReturnType%1000 == 109)
          {
          if (strcmp(fi->ReturnClass,currentFunction->ReturnClass))
            {
            match = 0;
            }
          }
        }
      if (match) return 1;
      }
    }
  return 0;
}

void HandleDataReader(FILE *fp, FileInfo *data)
{
    fprintf(fp,"\n  private native void ");
    fprintf(fp,"%s_%i(byte id0[],int id1);\n",
            currentFunction->Name,numberOfWrappedFunctions);
    fprintf(fp,"\n  public void ");
    fprintf(fp,"%s(byte id0[],int id1)\n",currentFunction->Name);
    fprintf(fp,"    { %s_%i(id0,id1); }\n",
            currentFunction->Name,numberOfWrappedFunctions);
    data = 0;
}

void outputFunction(FILE *fp, FileInfo *data)
{
  int i;
  int args_ok = 1;
 
  /* some functions will not get wrapped no matter what else */
  if (currentFunction->IsOperator || 
      currentFunction->ArrayFailure ||
      !currentFunction->IsPublic ||
      !currentFunction->Name) 
    {
    return;
    }

  /* NewInstance and SafeDownCast can not be wrapped because it is a
     (non-virtual) method which returns a pointer of the same type as
     the current pointer. Since all methods are virtual in Java, this
     looks like polymorphic return type.  */
  if (!strcmp("NewInstance",currentFunction->Name))
    {
    return ;
    }
  
  if (!strcmp("SafeDownCast",currentFunction->Name))
    {
    return ;
    }
  
  /* check to see if we can handle the args */
  for (i = 0; i < currentFunction->NumberOfArguments; i++)
    {
    if (currentFunction->ArgTypes[i]%1000 == 9) args_ok = 0;
    if ((currentFunction->ArgTypes[i]%10) == 8) args_ok = 0;
    if (((currentFunction->ArgTypes[i]%1000)/100 != 3)&&
        (currentFunction->ArgTypes[i]%1000 != 109)&&
        ((currentFunction->ArgTypes[i]%1000)/100)) args_ok = 0;
    if (currentFunction->ArgTypes[i]%1000 == 313) args_ok = 0;
    if (currentFunction->ArgTypes[i]%1000 == 314) args_ok = 0;
    if (currentFunction->ArgTypes[i]%1000 == 315) args_ok = 0;
    if (currentFunction->ArgTypes[i]%1000 == 316) args_ok = 0;
    }
  if ((currentFunction->ReturnType%10) == 8) args_ok = 0;
  if (currentFunction->ReturnType%1000 == 9) args_ok = 0;
  if (((currentFunction->ReturnType%1000)/100 != 3)&&
      (currentFunction->ReturnType%1000 != 109)&&
      ((currentFunction->ReturnType%1000)/100)) args_ok = 0;


  /* eliminate unsigned char * and unsigned short * */
  if (currentFunction->ReturnType%1000 == 314) args_ok = 0;
  if (currentFunction->ReturnType%1000 == 315) args_ok = 0;
  if (currentFunction->ReturnType%1000 == 316) args_ok = 0;

  if (currentFunction->NumberOfArguments && 
      (currentFunction->ArgTypes[0] == 5000)
      &&(currentFunction->NumberOfArguments != 1)) args_ok = 0;

  /* make sure we have all the info we need for array arguments in */
  for (i = 0; i < currentFunction->NumberOfArguments; i++)
    {
    if (((currentFunction->ArgTypes[i]%1000)/100 == 3)&&
  (currentFunction->ArgCounts[i] <= 0)&&
  (currentFunction->ArgTypes[i]%1000 != 309)&&
  (currentFunction->ArgTypes[i]%1000 != 303)) args_ok = 0;
    }

  /* if we need a return type hint make sure we have one */
  switch (currentFunction->ReturnType%1000)
    {
    case 301: case 302: case 307:
    case 304: case 305: case 306: case 313:
      args_ok = currentFunction->HaveHint;
      break;
    }
  
  /* make sure it isn't a Delete or New function */
  if (!strcmp("Delete",currentFunction->Name) ||
      !strcmp("New",currentFunction->Name))
    {
    args_ok = 0;
    }
  
  /* handle DataReader SetBinaryInputString as a special case */
  if (!strcmp("SetBinaryInputString",currentFunction->Name) &&
      (!strcmp("vtkDataReader",data->ClassName) ||
       !strcmp("vtkStructuredGridReader",data->ClassName) ||
       !strcmp("vtkRectilinearGridReader",data->ClassName) ||
       !strcmp("vtkUnstructuredGridReader",data->ClassName) ||
       !strcmp("vtkStructuredPointsReader",data->ClassName) ||
       !strcmp("vtkPolyDataReader",data->ClassName)))
      {
          HandleDataReader(fp,data);
          wrappedFunctions[numberOfWrappedFunctions] = currentFunction;
          numberOfWrappedFunctions++;
      }

  if (currentFunction->IsPublic && args_ok && 
      strcmp(data->ClassName,currentFunction->Name) &&
      strcmp(data->ClassName, currentFunction->Name + 1))
    {
    /* make sure we haven't already done one of these */
    if (!DoneOne())
      {
      fprintf(fp,"\n  private native ");
      return_result(fp);
      fprintf(fp,"%s_%i(",currentFunction->Name,numberOfWrappedFunctions);
      
      for (i = 0; i < currentFunction->NumberOfArguments; i++)
        {
        if (i)
          {
          fprintf(fp,",");
          }
        output_temp(fp,i);
        }
      fprintf(fp,");\n");
      fprintf(fp,"  public ");
      return_result(fp);
      fprintf(fp,"%s(",currentFunction->Name);
      
      for (i = 0; i < currentFunction->NumberOfArguments; i++)
        {
        if (i)
          {
          fprintf(fp,",");
          }
        output_temp(fp,i);
        }
      /* if not void then need return otherwise none */
      if (currentFunction->ReturnType%1000 == 2)
        {
        fprintf(fp,")\n    { %s_%i(",currentFunction->Name,
                numberOfWrappedFunctions);
        }
      else
        {
        fprintf(fp,")\n    { return %s_%i(",currentFunction->Name,
                numberOfWrappedFunctions);
        }
      for (i = 0; i < currentFunction->NumberOfArguments; i++)
        {
        if (i)
          {
          fprintf(fp,",");
          }
        fprintf(fp,"id%i",i);
        }
      if ((currentFunction->NumberOfArguments == 1) && 
          (currentFunction->ArgTypes[0] == 5000)) fprintf(fp,",id1");
      fprintf(fp,"); }\n");
      
      wrappedFunctions[numberOfWrappedFunctions] = currentFunction;
      numberOfWrappedFunctions++;
      }
    }
}

/* print the parsed structures */
void vtkParseOutput(FILE *fp, FileInfo *data)
{
  int i;
  
  fprintf(fp,"// java wrapper for %s object\n//\n",data->ClassName);
  fprintf(fp,"\npackage vtk;\n");

  if (strcmp("vtkObjectBase",data->ClassName))
    {
    fprintf(fp,"import vtk.*;\n");
    }
  fprintf(fp,"\npublic class %s",data->ClassName);
  if (strcmp("vtkObjectBase",data->ClassName))
    {
    if (data->NumberOfSuperClasses) 
      {
      fprintf(fp," extends %s",data->SuperClasses[0]);
      }
    }
  fprintf(fp,"\n{\n");

  /* insert function handling code here */
  for (i = 0; i < data->NumberOfFunctions; i++)
    {
    currentFunction = data->Functions + i;
    outputFunction(fp, data);
    }

  if (!data->NumberOfSuperClasses)
    {
    if (data->IsConcrete)
      {
      fprintf(fp,"\n  public %s() { this.VTKInit();};\n",data->ClassName);
      }
    else
      {
      fprintf(fp,"\n  public %s() { super();};\n",data->ClassName);
      }
    fprintf(fp,"\n  protected %s(int dmy) { super(); };\n",data->ClassName);
    fprintf(fp,"  protected int vtkId = 0;\n");

    
    /* if we are a base class and have a delete method */
    if (data->HasDelete)
      {
      fprintf(fp,"\n  public native void VTKDelete();\n");
      fprintf(fp,"  protected void finalize() { this.VTKDelete();};\n");
      }
    }
  /* Special case for vtkObject */
  else if ( strcmp("vtkObject",data->ClassName) == 0 )
    {
    fprintf(fp,"\n  public %s() { super(); this.VTKInit(); };\n",
            data->ClassName);
    fprintf(fp,"\n  protected %s(int dmy) { super(dmy); };\n",data->ClassName);
    }
  else
    {
    fprintf(fp,"\n  public %s() { super(); };\n",data->ClassName);
    fprintf(fp,"\n  protected %s(int dmy) { super(dmy); };\n",data->ClassName);
    }

  if (data->IsConcrete)
    {
    fprintf(fp,"  public native void   VTKInit();\n");
    }

  fprintf(fp,"  protected native void   VTKCastInit();\n");

  if (!strcmp("vtkObject",data->ClassName))
    {
    /* Add the Print method to vtkObject. */
    fprintf(fp,"  public native String Print();\n");
    /* Add the PrintRevisions method to vtkObject. */
    fprintf(fp,"  public native String PrintRevisions();\n");
    }

  if (!strcmp("vtkObject",data->ClassName))
    {
    fprintf(fp,"  public native int AddObserver(String id0, Object id1, String id2);\n");
    }
  fprintf(fp,"\n}\n");
  {
  int cc;
  int len;
  char *dir;
  char *fname;
  char javaDone[] = "VTKJavaWrapped";
  FILE* tfp;
  fname = data->OutputFileName;
  dir = (char*)malloc(strlen(fname) + strlen(javaDone) + 2);
  sprintf(dir, "%s", fname);
  len = (int)strlen(dir); 
  for ( cc = len-1; cc > 0; cc -- )
    {
    if ( dir[cc] == '/' || dir[cc] == '\\' )
      {
      dir[cc+1] = 0;
      break;
      }
    }
  strcat(dir, javaDone);
  tfp = fopen(dir, "w");
  if ( tfp )
    {
    fprintf(tfp, "File: %s\n", fname);
    fclose(tfp);
    }
  }
}

