# get the interactor ui
source vtkInt.tcl
source "colors.tcl"
# create planes
# First create the render master
vtkRenderMaster rm;

# Now create the RenderWindow, Renderer and both Actors
#
set renWin [rm MakeRenderWindow];
set ren1   [$renWin MakeRenderer];
set iren [$renWin MakeRenderWindowInteractor];

# create pipeline
#
vtkPLOT3DReader pl3d;
    pl3d SetXYZFilename "../../data/combxyz.bin"
    pl3d SetQFilename "../../data/combq.bin"
    pl3d SetScalarFunctionNumber 100;
    pl3d SetVectorFunctionNumber 202;
    pl3d DebugOn;
    pl3d Update;
vtkStructuredGridGeometryFilter plane;
    plane SetInput [pl3d GetOutput];
    plane SetExtent 0 100 0 100 0 0;
vtkPolyMapper planeMapper;
    planeMapper SetInput [plane GetOutput];
    planeMapper SetScalarRange 0.197813 0.710419;
vtkActor planeActor;
    planeActor SetMapper planeMapper;

vtkStructuredGridOutlineFilter outline;
    outline SetInput [pl3d GetOutput];
vtkPolyMapper outlineMapper;
    outlineMapper SetInput [outline GetOutput];
vtkActor outlineActor;
    outlineActor SetMapper outlineMapper;
    eval [outlineActor GetProperty] SetColor $black;

# Add the actors to the renderer, set the background and size
#
$ren1 AddActors outlineActor;
$ren1 AddActors planeActor;
$ren1 SetBackground 1 1 1;
$renWin SetSize 750 750;
$iren Initialize;

set cam1 [$ren1 GetActiveCamera];
    $cam1 SetClippingRange 3.95297 50;
    $cam1 SetFocalPoint 8.88908 0.595038 29.3342;
    $cam1 SetPosition -12.3332 31.7479 41.2387;
    $cam1 CalcViewPlaneNormal;
    $cam1 SetViewUp 0.060772 -0.319905 0.945498;

# render the image
#
$iren SetUserMethod {wm deiconify .vtkInteract};

for {set j 0} {$j<3} {incr j 1} {
    for {set i 0} {$i<25} {incr i 1} {
        eval plane SetExtent 0 100 0 100 $i $i;
        $renWin Render;
    }
}

# prevent the tk window from showing up then start the event loop
wm withdraw .



