/*=========================================================================

  Program:   CMB
  Module:    qtCMBConeDialog.cxx

Copyright (c) 1998-2005 Kitware Inc. 28 Corporate Drive, Suite 204,
Clifton Park, NY, 12065, USA.

All rights reserved. No part of this software may be reproduced,
distributed,
or modified, in any form or by any means, without permission in writing from
Kitware Inc.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
EVEN IF THE AUTHORS HAVE BEEN ADiVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN
"AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO
PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
=========================================================================*/
// .NAME Represents a dialog editing a cone source.
// .SECTION Description
// .SECTION Caveats

#include "qtCMBConeDialog.h"

#include "pqPipelineSource.h"
#include "pqRenderView.h"
#include "pqAutoGeneratedObjectPanel.h"
#include "vtkSMSourceProxy.h"
#include <QDialog>
#include <QDialogButtonBox>
#include <QVBoxLayout>
//-----------------------------------------------------------------------------
qtCMBConeDialog::qtCMBConeDialog(
  pqPipelineSource* coneSource, pqRenderView* view) :
  Status(0), ConeSourcePanel(0)
{
  if(coneSource)
    {
    this->MainDialog = new QDialog();
    QVBoxLayout* layout = new QVBoxLayout(this->MainDialog);
    this->ConeSourcePanel =
      new pqAutoGeneratedObjectPanel(coneSource, false, this->MainDialog);
    this->ConeSourcePanel->setObjectName("ConeSourcePanel");
    layout->addWidget(ConeSourcePanel);
    this->ConeSourcePanel->setView(view);
    QDialogButtonBox* buttonBox=new QDialogButtonBox(
      this->MainDialog);
    buttonBox->setStandardButtons(
      QDialogButtonBox::Cancel|QDialogButtonBox::Ok);
    layout->addWidget(buttonBox);
    QObject::connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    QObject::connect(buttonBox, SIGNAL(rejected()), this, SLOT(cancel()));
    }
}

//-----------------------------------------------------------------------------
qtCMBConeDialog::~qtCMBConeDialog()
{
  if(this->ConeSourcePanel)
    {
    delete this->ConeSourcePanel;
    }
  if (this->MainDialog)
    {
    delete MainDialog;
    }
}
//-----------------------------------------------------------------------------
int qtCMBConeDialog::exec()
{
  this->MainDialog->setModal(true);
  this->MainDialog->show();
  this->MainDialog->exec();
  return this->Status;
}
//-----------------------------------------------------------------------------
void qtCMBConeDialog::accept()
{
  this->MainDialog->hide();
  vtkSMSourceProxy* smSource = vtkSMSourceProxy::SafeDownCast(
    this->ConeSourcePanel->proxy());
  smSource->MarkModified(NULL);
  smSource->UpdateVTKObjects();
  smSource->UpdatePipeline();
  this->ConeSourcePanel->accept();
  this->Status = 1;
}
//-----------------------------------------------------------------------------
void qtCMBConeDialog::cancel()
{
  this->MainDialog->hide();
  this->ConeSourcePanel->reset();
  this->Status = 0;
}
//-----------------------------------------------------------------------------
