/*=========================================================================

 Program:   Visualization Toolkit
 Module:    $RCSfile: pqCMBMeshReaderPanel.cxx,v $

 =========================================================================*/
#include "pqCMBMeshReaderPanel.h"

#include <QCheckBox>

pqCMBMeshReaderPanel::pqCMBMeshReaderPanel(pqProxy* pxy, QWidget* p)
: pqAutoGeneratedObjectPanel(pxy, p)
{
  // connect actions
  QObject::connect(this->findChild<QCheckBox*>("CreateMeshMaterialIdArray"),
    SIGNAL(stateChanged(int)), this, SLOT(updateMaterialControls(int)));
  // initialize
  updateMaterialControls(this->findChild<QCheckBox*>("CreateMeshMaterialIdArray")->checkState());
}

void pqCMBMeshReaderPanel::updateInformationAndDomains()
{
  pqAutoGeneratedObjectPanel::updateInformationAndDomains();
}

void pqCMBMeshReaderPanel::updateMaterialControls(int state)
{
  this->findChild<QWidget*>("RenameMaterialAsRegion")->setEnabled(state != 0);
  this->findChild<QWidget*>("_labelForRenameMaterialAsRegion")->setEnabled(state != 0);
}
