/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOSPRayTetrahedraMapperNode.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

/*
 * Copyright 2003 Sandia Corporation.
 * Under the terms of Contract DE-AC04-94AL85000, there is a non-exclusive
 * license for use of this work by or on behalf of the
 * U.S. Government. Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that this Notice and any
 * statement of authorship are reproduced on all copies.
 */

/**
 * @class   vtkOSPRayTetrahedraMapperNode
 * @brief   Unstructured grid volume renderer.
 *
 *
 * vtkOSPRayTetrahedraMapperNode is an implementation of the classic
 * Projected Tetrahedra algorithm presented by Shirley and Tuchman in "A
 * Polygonal Approximation to Direct Scalar Volume Rendering" in Computer
 * Graphics, December 1990.
 *
 * @bug
 * This mapper relies highly on the implementation of the OpenGL pipeline.
 * A typical hardware driver has lots of options and some settings can
 * cause this mapper to produce artifacts.
 *
*/

#ifndef vtkOSPRayTetrahedraMapperNode_h
#define vtkOSPRayTetrahedraMapperNode_h

#include "vtkRenderingOSPRayModule.h" // For export macro
#include "vtkVolumeMapperNode.h"

class vtkFloatArray;
class vtkPoints;
class vtkUnsignedCharArray;
class vtkVisibilitySort;
class vtkVolumeProperty;
class vtkRenderWindow;

namespace osp
{
  struct TransferFunction;
  struct Volume;
}


class VTKRENDERINGVOLUME_EXPORT vtkOSPRayTetrahedraMapperNode : public vtkVolumeMapperNode

{
public:
  vtkTypeMacro(vtkOSPRayTetrahedraMapperNode,
                       vtkVolumeMapperNode);
  static vtkOSPRayTetrahedraMapperNode *New();
  void PrintSelf(ostream &os, vtkIndent indent) VTK_OVERRIDE;

//  virtual void SetVisibilitySort(vtkVisibilitySort *sort);
//  vtkGetObjectMacro(VisibilitySort, vtkVisibilitySort);

  /**
   * Make ospray calls to render me.
   */
  virtual void Render(bool prepass) VTK_OVERRIDE;


//  static void MapScalarsToColors(vtkDataArray *colors,
//                                 vtkVolumeProperty *property,
//                                 vtkDataArray *scalars);
//  static void TransformPoints(vtkPoints *inPoints,
//                              const float projection_mat[16],
//                              const float modelview_mat[16],
//                              vtkFloatArray *outPoints);

//  /**
//   * Return true if the rendering context provides
//   * the nececessary functionality to use this class.
//   */
//  virtual bool IsSupported(vtkRenderWindow *)
//    { return false; }

protected:
  vtkOSPRayTetrahedraMapperNode();
  ~vtkOSPRayTetrahedraMapperNode() VTK_OVERRIDE;

  //TODO: SetAndGetters?
  int NumColors;
  double SamplingRate;

  vtkTimeStamp BuildTime;
  vtkTimeStamp PropertyTime;

  osp::Volume* OSPRayVolume;
  osp::TransferFunction* TransferFunction;
  std::vector<float> TFVals;
  std::vector<float> TFOVals;

//  vtkAbstractArray *GetArrayToProcess
//    (vtkDataSet* input, int& association);


//  vtkVisibilitySort *VisibilitySort;

  /**
   * The visibility sort will probably make a reference loop by holding a
   * reference to the input.
   */
//  void ReportReferences(vtkGarbageCollector *collector) VTK_OVERRIDE;

private:
  vtkOSPRayTetrahedraMapperNode(const vtkOSPRayTetrahedraMapperNode&) VTK_DELETE_FUNCTION;
  void operator=(const vtkOSPRayTetrahedraMapperNode &) VTK_DELETE_FUNCTION;
};

#endif
