/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOSPRayTetrahedraMapperNode.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

/*
 * Copyright 2003 Sandia Corporation.
 * Under the terms of Contract DE-AC04-94AL85000, there is a non-exclusive
 * license for use of this work by or on behalf of the
 * U.S. Government. Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that this Notice and any
 * statement of authorship are reproduced on all copies.
 */

#include "vtkOSPRayTetrahedraMapperNode.h"

#include "vtkArrayDispatch.h"
#include "vtkCellArray.h"
#include "vtkCellCenterDepthSort.h"
#include "vtkCellData.h"
#include "vtkColorTransferFunction.h"
#include "vtkDoubleArray.h"
#include "vtkFloatArray.h"
#include "vtkGarbageCollector.h"
#include "vtkMath.h"
#include "vtkObjectFactory.h"
#include "vtkPiecewiseFunction.h"
#include "vtkPointData.h"
#include "vtkTimerLog.h"
#include "vtkUnsignedCharArray.h"
#include "vtkUnstructuredGrid.h"
#include "vtkVisibilitySort.h"
#include "vtkVolume.h"
#include "vtkVolumeProperty.h"

#include <cmath>
#include <algorithm>

#include "ospray/ospray.h"

//-----------------------------------------------------------------------------
//vtkCxxSetObjectMacro(vtkOSPRayTetrahedraMapperNode,
//                     VisibilitySort, vtkVisibilitySort);

//-----------------------------------------------------------------------------
// Return NULL if no override is supplied.
//vtkAbstractObjectFactoryNewMacro(vtkOSPRayTetrahedraMapperNode)
vtkStandardNewMacro(vtkOSPRayTetrahedraMapperNode);

//-----------------------------------------------------------------------------

vtkOSPRayTetrahedraMapperNode::vtkOSPRayTetrahedraMapperNode()
{
//  this->VisibilitySort = vtkCellCenterDepthSort::New();
  std::cout << __PRETTY_FUNCTION__ << std::endl;
  this->SamplingRate=0.0;
  this->NumColors = 128;
  this->OSPRayVolume = NULL;
  this->TransferFunction = NULL;
}

vtkOSPRayTetrahedraMapperNode::~vtkOSPRayTetrahedraMapperNode()
{
//  this->SetVisibilitySort(NULL);{
  delete this->OSPRayVolume;
  ospRelease(this->TransferFunction);

}

void vtkOSPRayTetrahedraMapperNode::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

//----------------------------------------------------------------------------
void vtkOSPRayTetrahedraMapperNode::Render(bool prepass)
{
  if (prepass)
  {
    std::cout << "vtkOSPRayTetrahedraMapperNode: Render prepass\n";

    //TODO: put OSPRay code here

//    vtkVolumeNode* volNode = vtkVolumeNode::SafeDownCast(this->Parent);
//    vtkVolume* vol = vtkVolume::SafeDownCast(volNode->GetRenderable());
//    if (vol->GetVisibility() == false)
//    {
//      return;
//    }
//    vtkAbstractVolumeMapper* mapper = vtkAbstractVolumeMapper::SafeDownCast(this->GetRenderable());
//    if (!vol->GetProperty())
//    {
//      // this is OK, happens in paraview client side for instance
//      return;
//    }

//    vtkOSPRayRendererNode *orn =
//      static_cast<vtkOSPRayRendererNode *>(
//        this->GetFirstAncestorOfType("vtkOSPRayRendererNode"));

//    osp::Model* OSPRayModel = orn->GetOModel();

//    // make sure that we have scalar input and update the scalar input
//    if ( mapper->GetDataSetInput() == NULL )
//    {
//      //OK - PV cli/srv for instance vtkErrorMacro("VolumeMapper had no input!");
//      return;
//    }
//    mapper->GetInputAlgorithm()->UpdateInformation();
//    mapper->GetInputAlgorithm()->Update();

//    vtkImageData *data = vtkImageData::SafeDownCast(mapper->GetDataSetInput());
//    if (!data)
//    {
//      //vtkErrorMacro("VolumeMapper's Input has no data!");
//      return;
//    }

//    int fieldAssociation;
//    vtkDataArray *sa = vtkDataArray::SafeDownCast
//      (this->GetArrayToProcess(data, fieldAssociation));
//    if (!sa)
//    {
//      vtkErrorMacro("VolumeMapper's Input has no scalar array!");
//      return;
//    }
//    vtkDataArray *sca = NULL;
//    int ncomp = sa->GetNumberOfComponents();
//    if (ncomp>1)
//    {
//      int comp = 0;//mapper->GetArrayComponent(); not yet supported
//      /*
//      if (comp<0)
//      {
//        comp = 0;
//      }
//      if (comp>ncomp-1)
//      {
//        comp = ncomp-1;
//      }
//      */
//      sca = sa->NewInstance();
//      sca->SetNumberOfComponents(1);
//      sca->SetNumberOfTuples(sa->GetNumberOfTuples());
//      sca->CopyComponent(0, sa, comp);
//      sa = sca;
//    }
//    int ScalarDataType = sa->GetDataType();
//    void* ScalarDataPointer = sa->GetVoidPointer(0);
//    int dim[3];
//    data->GetDimensions(dim);
//    if (fieldAssociation == vtkDataObject::FIELD_ASSOCIATION_CELLS)
//    {
//      dim[0] = dim[0]-1;
//      dim[1] = dim[1]-1;
//      dim[2] = dim[2]-1;
//    }

//    std::string voxelType;
//    if (ScalarDataType == VTK_FLOAT)
//    {
//      voxelType = "float";
//    }
//    else if (ScalarDataType == VTK_UNSIGNED_CHAR)
//    {
//      voxelType = "uchar";
//    }
//    else if (ScalarDataType == VTK_UNSIGNED_SHORT)
//    {
//      voxelType = "ushort";
//    }
//    else if (ScalarDataType == VTK_SHORT)
//    {
//      voxelType = "ushort";
//    }
//    else if (ScalarDataType == VTK_DOUBLE)
//    {
//      voxelType = "double";
//    }
//    else
//    {
//      vtkErrorMacro("ERROR: Unsupported data type for ospray volumes, current supported data types are: float, uchar, and double.");
//      return;
//    }

//    if (!this->TransferFunction)
//    {
//      this->TransferFunction = ospNewTransferFunction("piecewise_linear");
//    }

//    // when input data is modified
//    if (mapper->GetDataSetInput()->GetMTime() > this->BuildTime)
//    {
//      delete this->OSPRayVolume;
//      this->OSPRayVolume = ospNewVolume("block_bricked_volume");

//      //
//      // Send Volumetric data to OSPRay

//      //
//      ospSet3i(this->OSPRayVolume, "dimensions", dim[0], dim[1], dim[2]);
//      double origin[3];
//      double scale[3];
//      data->GetOrigin(origin);
//      vol->GetScale(scale);
//      const double *bds = vol->GetBounds();
//      origin[0] = bds[0];
//      origin[1] = bds[2];
//      origin[2] = bds[4];

//      double spacing[3];
//      data->GetSpacing(spacing);
//      scale[0] = (bds[1]-bds[0])/double(dim[0]-1);
//      scale[1] = (bds[3]-bds[2])/double(dim[1]-1);
//      scale[2] = (bds[5]-bds[4])/double(dim[2]-1);

//      ospSet3f(this->OSPRayVolume, "gridOrigin", origin[0], origin[1], origin[2]);
//      ospSet3f(this->OSPRayVolume, "gridSpacing", scale[0], scale[1], scale[2]);
//      ospSetString(this->OSPRayVolume, "voxelType", voxelType.c_str());

//      osp::vec3i ll, uu;
//      ll.x = 0, ll.y = 0, ll.z = 0;
//      uu.x = dim[0], uu.y = dim[1], uu.z = dim[2];
//      ospSetRegion(this->OSPRayVolume, ScalarDataPointer, ll, uu);

//      ospSet2f(this->TransferFunction, "valueRange",
//               sa->GetRange()[0], sa->GetRange()[1]);
//    }

//    // test for modifications to volume properties
//    vtkVolumeProperty* volProperty = vol->GetProperty();
//    if (vol->GetProperty()->GetMTime() > this->PropertyTime
//        || mapper->GetDataSetInput()->GetMTime() > this->BuildTime)
//    {
//      vtkColorTransferFunction* colorTF =
//        volProperty->GetRGBTransferFunction(0);
//      vtkPiecewiseFunction *scalarTF = volProperty->GetScalarOpacity(0);

//      this->TFVals.resize(this->NumColors*3);
//      this->TFOVals.resize(this->NumColors);
//      scalarTF->GetTable(sa->GetRange()[0],
//                         sa->GetRange()[1],
//                         this->NumColors,
//                         &TFOVals[0]);
//      colorTF->GetTable(sa->GetRange()[0],
//                        sa->GetRange()[1],
//                        this->NumColors,
//                        &this->TFVals[0]);

//      OSPData colorData = ospNewData(this->NumColors,
//                                     OSP_FLOAT3,
//                                     &this->TFVals[0]);
//      ospSetData(this->TransferFunction, "colors", colorData);

//      OSPData tfAlphaData = ospNewData(NumColors, OSP_FLOAT, &TFOVals[0]);
//      ospSetData(this->TransferFunction, "opacities", tfAlphaData);

//      ospSetObject(this->OSPRayVolume, "transferFunction",
//                   this->TransferFunction);

//      ospSet1i(this->OSPRayVolume, "gradientShadingEnabled",
//               volProperty->GetShade());
//      this->PropertyTime.Modified();
//      ospRelease(colorData);
//      ospRelease(tfAlphaData);
//    }

//    ospSet1f(OSPRayVolume, "adaptiveMaxSamplingRate", 1.2f);
//    ospSet1f(OSPRayVolume, "adaptiveBacktrack", 0.01f);
//    ospSet1i(OSPRayVolume, "adaptiveSampling", 1); //turn off preIntegration
//    if (this->SamplingRate == 0.0f)  // 0 means automatic sampling rate
//    {
//      //automatically determine sampling rate
//      int minBound = std::min(std::min(dim[0],dim[1]),dim[2]);
//      float minSamplingRate = 0.075f; // lower for min adaptive sampling step
//      if (minBound < 100)
//      {
//        float s = (100.0f - minBound)/100.0f;
//        ospSet1f(this->OSPRayVolume, "samplingRate", s*6.f + 1.f);
//        ospSet1i(OSPRayVolume, "adaptiveSampling", 0); //turn off preIntegration
//      }
//      else if (minBound < 1000)
//      {
//        float s = std::min((900.0f - minBound)/1000.0f, 1.f);
//        float s_new = (s*s*s*(0.5f-minSamplingRate) + minSamplingRate);
//        ospSet1f(this->OSPRayVolume, "samplingRate", s_new);
//        ospSet1f(this->OSPRayVolume, "adaptiveMaxSamplingRate", 2.f);
//      }
//      else
//      {
//        ospSet1f(this->OSPRayVolume, "samplingRate", minSamplingRate);
//      }
//    }
//    else
//    {
//      ospSet1f(this->OSPRayVolume, "samplingRate", this->SamplingRate);
//    }
//    ospSet1f(OSPRayVolume, "adaptiveScalar", 15.f);
//    float rs = static_cast<float>(volProperty->GetSpecular(0)/16.); //16 chosen because near GL
//    float gs = static_cast<float>(volProperty->GetSpecular(1)/16.);
//    float bs = static_cast<float>(volProperty->GetSpecular(2)/16.);
//    ospSet3f(OSPRayVolume, "specular", rs,gs,bs);
//    ospSet1i(OSPRayVolume, "preIntegration", 0); //turn off preIntegration

//    this->RenderTime = volNode->GetMTime();
//    this->BuildTime.Modified();

//    ospCommit(this->TransferFunction);
//    ospCommit(this->OSPRayVolume);
//    ospAddVolume(OSPRayModel, this->OSPRayVolume);

//    if (sca)
//    {
//      sca->Delete();
//    }
    //ospCommit(OSPRayModel);
  }
}

//-----------------------------------------------------------------------------

//void vtkOSPRayTetrahedraMapperNode::ReportReferences(vtkGarbageCollector *collector)
//{
//  this->Superclass::ReportReferences(collector);

//  vtkGarbageCollectorReport(collector, this->VisibilitySort, "VisibilitySort");
//}

//-----------------------------------------------------------------------------
//namespace {
//struct TransformPointsWorker
//{
//  const float *Proj;
//  const float *ModelView;
//  float *OutPoints;

//  TransformPointsWorker(const float *proj, const float *mv, float *out)
//    : Proj(proj), ModelView(mv), OutPoints(out)
//  {}

//  template<class ArrayT>
//  void operator()(ArrayT *in_points)
//  {
//    float mat[16];
//    int row, col;
//    vtkIdType i;
//    vtkIdType num_points = in_points->GetNumberOfTuples();
//    typename ArrayT::ValueType in_p[3];
//    float *out_p;

//    // Combine two transforms into one transform.
//    for (col = 0; col < 4; col++)
//    {
//      for (row = 0; row < 4; row++)
//      {
//        mat[col*4+row] = (  this->Proj[0*4+row] * this->ModelView[col*4+0]
//                          + this->Proj[1*4+row] * this->ModelView[col*4+1]
//                          + this->Proj[2*4+row] * this->ModelView[col*4+2]
//                          + this->Proj[3*4+row] * this->ModelView[col*4+3]);
//      }
//    }

//    // Transform all points.
//    for (i = 0, out_p = this->OutPoints; i < num_points; i++, out_p += 3)
//    {
//      in_points->GetTypedTuple(i, in_p);
//      for (row = 0; row < 3; row++)
//      {
//        out_p[row] = (  mat[0*4+row] * in_p[0] + mat[1*4+row] * in_p[1]
//                      + mat[2*4+row] * in_p[2] + mat[3*4+row]);
//      }
//    }

//    // Check to see if we need to divide by w.
//    if (   (mat[0*4+3] != 0) || (mat[1*4+3] != 0)
//        || (mat[2*4+3] != 0) || (mat[3*4+3] != 1) )
//    {
//      for (i = 0, out_p = this->OutPoints; i < num_points; i++, out_p += 3)
//      {
//        in_points->GetTypedTuple(i, in_p);
//        float w = (  mat[0*4+3]*in_p[0] + mat[1*4+3]*in_p[1]
//                   + mat[2*4+3]*in_p[2] + mat[3*4+3]);
//        if (w > 0.0)
//        {
//          out_p[0] /= w;
//          out_p[1] /= w;
//          out_p[2] /= w;
//        }
//        else
//        {
//          // A negative w probably means the point is behind the viewer.  Things
//          // can get screwy if we try to inverse-project that.  Instead, just
//          // set the position somewhere very far behind us.
//          out_p[2] = -VTK_FLOAT_MAX;
//        }
//      }
//    }
//  }

//};
//} // end anon namespace

////-----------------------------------------------------------------------------
//void vtkOSPRayTetrahedraMapperNode::TransformPoints(
//                                                 vtkPoints *inPoints,
//                                                 const float projection_mat[16],
//                                                 const float modelview_mat[16],
//                                                 vtkFloatArray *outPoints)
//{
//  if (!inPoints)
//  {
//    return;
//  }
//  outPoints->SetNumberOfComponents(3);
//  outPoints->SetNumberOfTuples(inPoints->GetNumberOfPoints());
//  TransformPointsWorker worker(projection_mat, modelview_mat,
//                               outPoints->GetPointer(0));
//  vtkArrayDispatch::Dispatch::Execute(inPoints->GetData(), worker);
//}

////-----------------------------------------------------------------------------

//namespace vtkOSPRayTetrahedraMapperNodeNamespace
//{
//  template <typename ColorArrayT, typename ScalarArrayT>
//  void MapScalarsToColorsImpl(ColorArrayT *colors, vtkVolumeProperty *property,
//                              ScalarArrayT *scalars);
//  template <typename ColorArrayT, typename ScalarArrayT>
//  void MapIndependentComponents(ColorArrayT *colors,
//                                vtkVolumeProperty *property,
//                                ScalarArrayT *scalars);
//  template <typename ColorArrayT, typename ScalarArrayT>
//  void Map2DependentComponents(ColorArrayT *colors, vtkVolumeProperty *property,
//                               ScalarArrayT *scalars);
//  template <typename ColorArrayT, typename ScalarArrayT>
//  void Map4DependentComponents(ColorArrayT *colors, ScalarArrayT *scalars);

//  struct Worker
//  {
//    vtkVolumeProperty *Property;

//    Worker(vtkVolumeProperty *property) : Property(property) {}

//    template <typename ColorArrayT, typename ScalarArrayT>
//    void operator()(ColorArrayT *colors, ScalarArrayT *scalars)
//    {
//      MapScalarsToColorsImpl(colors, this->Property, scalars);
//    }
//  };
//}

//void vtkOSPRayTetrahedraMapperNode::MapScalarsToColors(
//                                                    vtkDataArray *colors,
//                                                    vtkVolumeProperty *property,
//                                                    vtkDataArray *scalars)
//{
//  using namespace vtkOSPRayTetrahedraMapperNodeNamespace;

//  vtkDataArray *tmpColors;
//  int castColors;

//  if (   (colors->GetDataType() == VTK_UNSIGNED_CHAR)
//         && ((   (scalars->GetDataType() != VTK_UNSIGNED_CHAR)
//                 || (property->GetIndependentComponents()) )
//             || ((!property->GetIndependentComponents())
//                 && (scalars->GetNumberOfComponents() == 2))) )
//  {
//    // Special case.  Need to convert from range [0,1] to [0,255].
//    tmpColors = vtkDoubleArray::New();
//    castColors = 1;
//  }
//  else
//  {
//    tmpColors = colors;
//    castColors = 0;
//  }

//  vtkIdType numscalars = scalars->GetNumberOfTuples();

//  tmpColors->Initialize();
//  tmpColors->SetNumberOfComponents(4);
//  tmpColors->SetNumberOfTuples(numscalars);

//  Worker worker(property);
//  if (!vtkArrayDispatch::Dispatch2::Execute(tmpColors, scalars, worker))
//  {
//    vtkGenericWarningMacro("Dispatch failed for scalar array "
//                           << scalars->GetName());
//  }

//  if (castColors)
//  {
//    // Special case.  Need to convert from range [0,1] to [0,255].
//    colors->Initialize();
//    colors->SetNumberOfComponents(4);
//    colors->SetNumberOfTuples(scalars->GetNumberOfTuples());

//    unsigned char *c
//      = static_cast<vtkUnsignedCharArray *>(colors)->GetPointer(0);

//    for (vtkIdType i = 0; i < numscalars; i++, c+= 4)
//    {
//      double *dc = tmpColors->GetTuple(i);
//      c[0] = static_cast<unsigned char>(dc[0]*255.9999);
//      c[1] = static_cast<unsigned char>(dc[1]*255.9999);
//      c[2] = static_cast<unsigned char>(dc[2]*255.9999);
//      c[3] = static_cast<unsigned char>(dc[3]*255.9999);
//    }

//    tmpColors->Delete();
//  }
//}

////-----------------------------------------------------------------------------
//namespace vtkOSPRayTetrahedraMapperNodeNamespace
//{
//  template <typename ColorArrayT, typename ScalarArrayT>
//  void MapScalarsToColorsImpl(ColorArrayT *colors, vtkVolumeProperty *property,
//                              ScalarArrayT *scalars)
//  {
//    if (property->GetIndependentComponents())
//    {
//      MapIndependentComponents(colors, property, scalars);
//    }
//    else
//    {
//      switch (scalars->GetNumberOfComponents())
//      {
//        case 2:
//          Map2DependentComponents(colors, property, scalars);
//          break;
//        case 4:
//          Map4DependentComponents(colors, scalars);
//          break;
//        default:
//          vtkGenericWarningMacro("Attempted to map scalar with "
//                                 << scalars->GetNumberOfComponents()
//                                 << " with dependent components");
//          break;
//      }
//    }
//  }

//  template <typename ColorArrayT, typename ScalarArrayT>
//  void MapIndependentComponents(ColorArrayT *colors,
//                                vtkVolumeProperty *property,
//                                ScalarArrayT *scalars)
//  {
//    // I don't really know what to do if there is more than one component.
//    // How am I supposed to mix the resulting colors?  Since I don't know
//    // what to do, and the whole thing seems kinda pointless anyway, I'm just
//    // going to punt and copy over the first scalar.
//    vtkIdType i;
//    vtkIdType num_scalars = scalars->GetNumberOfTuples();

//    typedef typename ScalarArrayT::ValueType ScalarType;
//    typedef typename ColorArrayT::ValueType ColorType;
//    ColorType c[4];

//    if (property->GetColorChannels() == 1)
//    {
//      vtkPiecewiseFunction *gray = property->GetGrayTransferFunction();
//      vtkPiecewiseFunction *alpha = property->GetScalarOpacity();

//      for (i = 0; i < num_scalars; i++)
//      {
//        ScalarType s = scalars->GetTypedComponent(i, 0);
//        c[0] = c[1] = c[2] = static_cast<ColorType>(gray->GetValue(s));
//        c[3] = static_cast<ColorType>(alpha->GetValue(s));
//        colors->SetTypedTuple(i, c);
//      }
//    }
//    else
//    {
//      vtkColorTransferFunction *rgb = property->GetRGBTransferFunction();
//      vtkPiecewiseFunction *alpha = property->GetScalarOpacity();

//      for (i = 0; i < num_scalars; i++)
//      {
//        ScalarType s = scalars->GetTypedComponent(i, 0);
//        double trgb[3];
//        rgb->GetColor(s, trgb);
//        c[0] = static_cast<ColorType>(trgb[0]);
//        c[1] = static_cast<ColorType>(trgb[1]);
//        c[2] = static_cast<ColorType>(trgb[2]);
//        c[3] = static_cast<ColorType>(alpha->GetValue(s));
//        colors->SetTypedTuple(i, c);
//      }
//    }
//  }

//  template <typename ColorArrayT, typename ScalarArrayT>
//  void Map2DependentComponents(ColorArrayT *colors, vtkVolumeProperty *property,
//                               ScalarArrayT *scalars)
//  {
//    typedef typename ScalarArrayT::ValueType ScalarType;
//    vtkColorTransferFunction *rgb = property->GetRGBTransferFunction();
//    vtkPiecewiseFunction *alpha = property->GetScalarOpacity();
//    vtkIdType num_scalars = scalars->GetNumberOfTuples();
//    double rgbColor[4];
//    ScalarType scalar[2];

//    for (vtkIdType i = 0; i < num_scalars; i++)
//    {
//      scalars->GetTypedTuple(i, scalar);
//      rgb->GetColor(scalar[0], rgbColor);
//      rgbColor[3] = alpha->GetValue(scalar[1]);
//      colors->SetTuple(i, rgbColor);
//    }
//  }

//  template <typename ColorArrayT, typename ScalarArrayT>
//  void Map4DependentComponents(ColorArrayT *colors, ScalarArrayT *scalars)
//  {
//    double val[4];
//    vtkIdType num_scalars = scalars->GetNumberOfTuples();
//    for (vtkIdType i = 0; i < num_scalars; i++)
//    {
//      scalars->GetTuple(i, val);
//      colors->SetTuple(i, val);
//    }
//  }

//}
