/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOSPRayAMRVolumeMapperNode.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

*/
// .NAME vtkOSPRayAMRVolumeMapperNode - links vtkVolumeMapper  to OSPRay
// .SECTION Description
// Translates vtkVolumeMapper state into OSPRay rendering calls

#ifndef vtkOSPRayAMRVolumeMapperNode_h
#define vtkOSPRayAMRVolumeMapperNode_h

#include "vtkRenderingOSPRayModule.h" // For export macro
#include "vtkOSPRayVolumeMapperNode.h"

#include <map>


class vtkVolume;
class ospVolume;
namespace osp {
struct Model;
struct Volume;
struct Renderer;
struct TransferFunction;
}
typedef osp::Model *OSPModel;
typedef osp::Volume *OSPVolume;
typedef osp::TransferFunction *OSPTransferFunction;


struct vtkOSPRayAMRVolumeCacheEntry
{
  osp::Volume* Volume;
  vtkTimeStamp BuildTime;
  vtkTimeStamp PropertyTime;
  float SamplingRate;
};

class VTKRENDERINGOSPRAY_EXPORT vtkOSPRayAMRVolumeMapperNode :
  public vtkOSPRayVolumeMapperNode
{
public:
  static vtkOSPRayAMRVolumeMapperNode* New();
  vtkTypeMacro(vtkOSPRayAMRVolumeMapperNode, vtkVolumeMapperNode);
  void PrintSelf(ostream& os, vtkIndent indent);
  //Description:
  //Traverse graph in ospray's prefered order and render
  virtual void Render(bool prepass);
  void SetCacheKey(double key)
  {
    CacheKey = key;
  }
protected:
  void Init();
  vtkOSPRayAMRVolumeMapperNode();
  ~vtkOSPRayAMRVolumeMapperNode();

private:
  vtkOSPRayAMRVolumeMapperNode(const vtkOSPRayAMRVolumeMapperNode&) VTK_DELETE_FUNCTION;
  void operator=(const vtkOSPRayAMRVolumeMapperNode&) VTK_DELETE_FUNCTION;
  OSPVolume ospVolume;
  std::map<double, vtkOSPRayAMRVolumeCacheEntry*> Cache;
  double CacheKey;
  double range[2];
  OSPTransferFunction transferFunction;
  bool Initialized;
  float samplingRate;
  float oldSamplingRate;
};
#endif
