/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOSPRayVolumeMapper.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkOSPRayVolumeMapper.h"

#include "vtkObjectFactory.h"
#include "vtkDataSet.h"
#include "vtkExecutive.h"
#include "vtkGarbageCollector.h"
#include "vtkImageData.h"
#include "vtkInformation.h"
#include "vtkRenderer.h"
#include "vtkOSPRayPass.h"

#include "vtkRenderWindow.h"

// ----------------------------------------------------------------------------
vtkOSPRayVolumeMapper::vtkOSPRayVolumeMapper()
{
  this->InternalRenderer = nullptr;
  this->InternalOSPRayPass = nullptr;
  Initialized = false;
}

// ----------------------------------------------------------------------------
vtkOSPRayVolumeMapper::~vtkOSPRayVolumeMapper()
{
  cerr << "DESTRUCT" << endl;
  cout << "DESTRUCT2" << endl;
  printf("destruct\n");
  if (this->InternalRenderer)
    {
    this->InternalRenderer->SetPass(NULL);
    this->InternalRenderer->Delete();
    }
  if (this->InternalOSPRayPass)
    {
    this->InternalOSPRayPass->Delete();
    }
  this->ZBuffer.clear();
}

//============================================================================
vtkStandardNewMacro(vtkOSPRayVolumeMapper)

// ----------------------------------------------------------------------------
void vtkOSPRayVolumeMapper::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}

// ----------------------------------------------------------------------------
void vtkOSPRayVolumeMapper::Init()
{
  this->InternalRenderer = vtkRenderer::New();
  this->InternalOSPRayPass = vtkOSPRayPass::New();
  Initialized = true;
}

// Render the volume
void vtkOSPRayVolumeMapper::Render(vtkRenderer *ren, vtkVolume *vol)
{
  if (!Initialized)
    Init();
  if (!ren)
    return;
  this->InternalRenderer->SetRenderWindow(ren->GetRenderWindow());
  this->InternalRenderer->SetActiveCamera(ren->GetActiveCamera());
  this->InternalRenderer->SetBackground(ren->GetBackground());
  if (!this->InternalRenderer->HasViewProp(vol))
    {
    this->InternalRenderer->RemoveAllViewProps();
    this->InternalRenderer->AddVolume(vol);
    } 
  this->InternalRenderer->SetPass(this->InternalOSPRayPass);
  this->InternalRenderer->SetLayer(0); //TODO: hacked in for now
  this->InternalRenderer->SetErase(0);
  this->InternalRenderer->Render();
  this->InternalRenderer->SetPass(0);
}

// Release any graphics resources that are being consumed by this mapper.
// The parameter window could be used to determine which graphic
// resources to release.
void vtkOSPRayVolumeMapper::ReleaseGraphicsResources(vtkWindow *)
{
}

// ----------------------------------------------------------------------------
void vtkOSPRayVolumeMapper::ReportReferences(vtkGarbageCollector* collector)
{
  // Report references held by this object that may be in a loop.
  this->Superclass::ReportReferences(collector);
  vtkGarbageCollectorReport(collector, this->InternalRenderer, "InternalRenderer");
  vtkGarbageCollectorReport(collector, this->InternalOSPRayPass, "OSP ");
}

// ----------------------------------------------------------------------------
void vtkOSPRayVolumeMapper::Register(vtkObjectBase* o)
{
  this->RegisterInternal(o, 1);
}

// ----------------------------------------------------------------------------
void vtkOSPRayVolumeMapper::UnRegister(vtkObjectBase* o)
{
  this->UnRegisterInternal(o, 1);
}