/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.web3d.vrml.export.compressors.CodeInputUnpacker;
import org.web3d.vrml.export.compressors.CodeOutputPacker;
import org.web3d.vrml.export.compressors.LZWByteStack;
import org.web3d.vrml.export.compressors.LZWHistoryItem;

public class LZW {
    private static final int NUM_BITS = 16;
    private static int largestCode = 0;
    private static int width = 9;
    private static final int SHIFTCOUNT = 8;
    private static final int MAXVALUE = 65535;
    private static final int MAXCODE = 65534;
    private static int TABLESIZE = 5021;

    public static int Compress(InputStream inputStream, CodeOutputPacker codeOutputPacker) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 256;
        LZWHistoryItem[] lZWHistoryItemArray = new LZWHistoryItem[TABLESIZE];
        int n4 = inputStream.read();
        ++n2;
        while (-1 != (n = inputStream.read())) {
            ++n2;
            int n5 = LZW.FindMatch(lZWHistoryItemArray, n4, n);
            if (lZWHistoryItemArray[n5] != null) {
                n4 = lZWHistoryItemArray[n5].Code;
                continue;
            }
            codeOutputPacker.putN(n4);
            if (n3 <= 65534) {
                lZWHistoryItemArray[n5] = new LZWHistoryItem(n3++, n4, n);
            }
            n4 = n;
        }
        codeOutputPacker.putN(n4);
        codeOutputPacker.putN(65535);
        codeOutputPacker.flush();
        if (n3 > largestCode) {
            largestCode = n3;
        }
        return n2;
    }

    public static int Compress(byte[] byArray, CodeOutputPacker codeOutputPacker) throws IOException {
        return LZW.Compress(byArray, byArray.length, codeOutputPacker);
    }

    public static int Compress(byte[] byArray, int n, CodeOutputPacker codeOutputPacker) throws IOException {
        int n2 = 0;
        int n3 = 256;
        LZWHistoryItem[] lZWHistoryItemArray = new LZWHistoryItem[TABLESIZE];
        int n4 = byArray[n2++];
        n4 &= 0xFF;
        while (n2 < byArray.length && n2 < n) {
            int n5 = byArray[n2++];
            int n6 = LZW.FindMatch(lZWHistoryItemArray, n4, n5 &= 0xFF);
            if (lZWHistoryItemArray[n6] != null) {
                n4 = lZWHistoryItemArray[n6].Code;
                continue;
            }
            codeOutputPacker.putN(n4);
            if (n3 <= 65534) {
                lZWHistoryItemArray[n6] = new LZWHistoryItem(n3++, n4, n5);
            }
            n4 = n5;
        }
        codeOutputPacker.putN(n4);
        codeOutputPacker.putN(65535);
        codeOutputPacker.flush();
        return n2;
    }

    private static int FindMatch(LZWHistoryItem[] lZWHistoryItemArray, int n, int n2) {
        int n3 = n2 << 8 ^ n;
        int n4 = n3 == 0 ? 1 : TABLESIZE - n3;
        while (lZWHistoryItemArray[n3] != null && (lZWHistoryItemArray[n3].Prefix != n || lZWHistoryItemArray[n3].Append != n2)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += TABLESIZE;
        }
        return n3;
    }

    public static int Expand(CodeInputUnpacker codeInputUnpacker, OutputStream outputStream) throws IOException, IllegalArgumentException {
        int n = 0;
        LZWByteStack lZWByteStack = new LZWByteStack();
        LZWHistoryItem[] lZWHistoryItemArray = new LZWHistoryItem[TABLESIZE];
        int n2 = 256;
        int n3 = codeInputUnpacker.getN();
        if (n3 > 255) {
            throw new IllegalArgumentException("Not LZW compressed data");
        }
        int n4 = n3;
        outputStream.write(n4);
        ++n;
        try {
            int n5;
            while (65535 != (n5 = codeInputUnpacker.getN())) {
                int n6;
                if (n5 >= n2) {
                    lZWByteStack.push(n4);
                    n6 = 1 + LZW.DecodeString(lZWHistoryItemArray, lZWByteStack, n3);
                } else {
                    n6 = LZW.DecodeString(lZWHistoryItemArray, lZWByteStack, n5);
                }
                n4 = lZWByteStack.pop();
                outputStream.write(n4);
                ++n;
                while (1 < n6--) {
                    outputStream.write(lZWByteStack.pop());
                    ++n;
                }
                if (n2 > 65534) continue;
                lZWHistoryItemArray[n2] = new LZWHistoryItem(n2, n3, n4);
                ++n2;
                n3 = n5;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Not LZW compressed data");
        }
        return n;
    }

    public static int Expand(CodeInputUnpacker codeInputUnpacker, byte[] byArray) throws IOException, IllegalArgumentException {
        int n = 0;
        LZWByteStack lZWByteStack = new LZWByteStack();
        LZWHistoryItem[] lZWHistoryItemArray = new LZWHistoryItem[TABLESIZE];
        int n2 = 256;
        int n3 = codeInputUnpacker.getN();
        if (n3 > 255) {
            throw new IllegalArgumentException("Not LZW compressed data");
        }
        int n4 = n3;
        byArray[n++] = (byte)n4;
        try {
            int n5;
            while (65535 != (n5 = codeInputUnpacker.getN())) {
                int n6;
                if (n5 >= n2) {
                    lZWByteStack.push(n4);
                    n6 = 1 + LZW.DecodeString(lZWHistoryItemArray, lZWByteStack, n3);
                } else {
                    n6 = LZW.DecodeString(lZWHistoryItemArray, lZWByteStack, n5);
                }
                int n7 = n++;
                n4 = lZWByteStack.pop();
                byArray[n7] = (byte)n4;
                while (1 < n6--) {
                    byArray[n++] = (byte)lZWByteStack.pop();
                }
                if (n2 > 65534) continue;
                lZWHistoryItemArray[n2] = new LZWHistoryItem(n2, n3, n4);
                ++n2;
                n3 = n5;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Not LZW compressed data");
        }
        return n;
    }

    private static int DecodeString(LZWHistoryItem[] lZWHistoryItemArray, LZWByteStack lZWByteStack, int n) {
        int n2 = 1;
        while (n > 255) {
            lZWByteStack.push(lZWHistoryItemArray[n].Append);
            n = lZWHistoryItemArray[n].Prefix;
            ++n2;
        }
        lZWByteStack.push((byte)n);
        return n2;
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        Object object2;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("1 12 123\na ab abc abcd abcde abcdef\nb bc bcd bcde bcdef\na ab abc abcd abcde abcdef\nb bc bcd bcde bcdef\nc cd cde cdef".getBytes());
            object2 = new CodeOutputPacker(5000);
            n = LZW.Compress(byteArrayInputStream, (CodeOutputPacker)object2);
            object = ((CodeOutputPacker)object2).toByteArray();
            System.out.println("compressed size: " + ((byte[])object).length);
            int n2 = LZW.Expand(new CodeInputUnpacker((byte[])object, 16), System.out);
            System.out.println("\nOK " + n + " -> " + n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("\n-------");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                object2 = new BufferedInputStream(new FileInputStream(new File(stringArray[i])));
                object = new CodeOutputPacker(250000, 16);
                n = LZW.Compress((InputStream)object2, (CodeOutputPacker)object);
                byte[] byArray = ((CodeOutputPacker)object).toByteArray();
                System.out.println("compressed size: " + byArray.length + " orig: " + n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\n-------");
        }
    }

    static {
        System.out.println("LZW static: 16");
        switch (16) {
            case 12: {
                TABLESIZE = 5021;
                break;
            }
            case 16: {
                TABLESIZE = 65729;
                break;
            }
            case 20: {
                TABLESIZE = 1262099;
                break;
            }
            default: {
                System.out.println("Unhandled table size: 16");
            }
        }
    }
}

