/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture3DNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTexture3DNode;

public class BasePixelTexture3D
extends BaseTexture3DNode {
    protected static final int FIELD_IMAGE = 4;
    private static final int LAST_PIXELTEXTURE_INDEX = 4;
    private static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfImage = FieldConstants.EMPTY_MFIMAGE;
    protected int vfImageLen;

    protected BasePixelTexture3D() {
        super("PixelTexture3D");
        this.hasChanged = new boolean[5];
    }

    protected BasePixelTexture3D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLTexture3DNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("image");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfImage = new int[vRMLFieldData.numElements];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfImage, 0, vRMLFieldData.numElements);
            this.vfImageLen = vRMLFieldData.numElements;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getCacheString(int n) {
        return null;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 50;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfImage;
                vRMLFieldData.numElements = this.vfImageLen;
                vRMLFieldData.dataType = (short)9;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfImage, this.vfImageLen);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 4: {
                if (n2 > this.vfImage.length) {
                    this.vfImage = new int[n2];
                }
                System.arraycopy(nArray, 0, this.vfImage, 0, n2);
                this.vfImageLen = n2;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BasePixelTexture3D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePixelTexture3D.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BasePixelTexture3D.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BasePixelTexture3D.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFBool", "repeatR");
        BasePixelTexture3D.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFImage", "image");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("image", n);
        fieldMap.put("set_image", n);
        fieldMap.put("image_changed", n);
        fieldMap.put("repeatS", new Integer(1));
        fieldMap.put("repeatT", new Integer(2));
        fieldMap.put("repeatR", new Integer(3));
    }
}

