/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOSPRayAMRVolumeMapperNode.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

*/
// .NAME vtkOSPRayAMRVolumeMapperNode - links vtkVolumeMapper  to OSPRay
// .SECTION Description
//
// Translates vtkAMRVolumeMapper state into OSPRay rendering calls
// Directly samples the vtkAMR data structure without resampling
// Data is expected to be overlapping, only floats and doubles are now
// supported.
//

#ifndef vtkOSPRayAMRVolumeMapperNode_h
#define vtkOSPRayAMRVolumeMapperNode_h

#include "vtkRenderingOSPRayModule.h" // For export macro
#include "vtkOSPRayVolumeMapperNode.h"

#include <map>


class vtkVolume;
class ospVolume;
namespace osp {
  struct Model;
  struct Volume;
  struct Renderer;
  struct TransferFunction;
}
typedef osp::Model *OSPModel;
typedef osp::Volume *OSPVolume;
typedef osp::TransferFunction *OSPTransferFunction;


class VTKRENDERINGOSPRAY_EXPORT vtkOSPRayAMRVolumeMapperNode :
  public vtkOSPRayVolumeMapperNode
{
public:
  static vtkOSPRayAMRVolumeMapperNode* New();
  vtkTypeMacro(vtkOSPRayAMRVolumeMapperNode, vtkVolumeMapperNode);
  void PrintSelf(ostream& os, vtkIndent indent);
  /**
  * Traverse graph in ospray's prefered order and render
  */
  virtual void Render(bool prepass);
  //** Set the cache entry key that volumes will be stored to */
  void SetCacheKey(double key);
protected:
  vtkOSPRayAMRVolumeMapperNode();
  ~vtkOSPRayAMRVolumeMapperNode();

private:
  vtkOSPRayAMRVolumeMapperNode(const vtkOSPRayAMRVolumeMapperNode&) VTK_DELETE_FUNCTION;
  void operator=(const vtkOSPRayAMRVolumeMapperNode&) VTK_DELETE_FUNCTION;

  // AMR Volume Cache
  struct vtkOSPRayAMRVolumeCacheEntry
  {
    osp::Volume* Volume;
    vtkTimeStamp BuildTime;
    vtkTimeStamp PropertyTime;
    float SamplingRate;
  };

  OSPVolume ospVolume;
  std::map<double, vtkOSPRayAMRVolumeCacheEntry*> Cache;
  double CacheKey;
  OSPTransferFunction TransferFunction;
  float SamplingRate;
  float OldSamplingRate;

};
#endif
