#!/bin/sh

# master - Sep 5, 2019
VTKM_HASH=64ad158124a0c0c720143b5286719327cc64c130
SHORT_HASH=${VTKM_HASH:0:8}

cp install_adios2.sh ubuntu18
cp install_vtkm.sh ubuntu18
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  -t kitware/vtk:ci-adis-vtkm${SHORT_HASH}-latest \
  ubuntu18/
rm ubuntu18/install_adios2.sh
rm ubuntu18/install_vtkm.sh
docker push kitware/vtk:ci-adis-vtkm${SHORT_HASH}-latest

cp install_adios2.sh ubuntu18-ompi
cp install_vtkm.sh ubuntu18-ompi
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  -t kitware/vtk:ci-adis-vtkm${SHORT_HASH}-ompi-latest \
  ubuntu18-ompi/
rm ubuntu18-ompi/install_adios2.sh
rm ubuntu18-ompi/install_vtkm.sh
docker push kitware/vtk:ci-adis-vtkm${SHORT_HASH}-ompi-latest

#edit names in .gitlab-ci.yml
sed -i '' -e "s/ci-adis-vtkm[a-zA-Z0-9]\{8\}/ci-adis-vtkm${SHORT_HASH}/g" ../../../.gitlab-ci.yml
