#!/usr/bin/env bash

set -e
set -x
shopt -s dotglob

readonly name="rapidjson"
readonly ownership="RapidJSON Upstream <kwrobot@kitware.com>"
readonly subtree="thirdparty/$name/adis$name"
readonly repo="https://gitlab.kitware.com/third-party/rapidjson.git"
readonly tag="for/adis-20200210-master"
readonly paths="
.gitattributes
include
license.txt
readme.md
"

extract_source () {
    git_archive
    pushd "$extractdir/$name-reduced"
    mv include/rapidjson include/adisrapidjson
    popd
}

. "${BASH_SOURCE%/*}/../update-common.sh"
