import adios2
from mpi4py import MPI
import numpy

comm = MPI.COMM_WORLD
rank = comm.Get_rank()
size = comm.Get_size()

adios = adios2.ADIOS(MPI.COMM_WORLD, adios2.DebugON)
bpIO = adios.DeclareIO("BPFile")
bpIO.SetEngine('bp4')

bpIO.DefineAttribute("ADIS_Data_Model", "xgc")

varList = ["dpot", "pot0", "potm0"]

bpIO.DefineAttribute("ADIS_Variable_List", varList)

varAssoc = []
varSources = []
arrayTypes = []
for i in range(len(varList)):
    varSources.append("3d")
    varAssoc.append("points")
    arrayTypes.append("xgc_field")

bpIO.DefineAttribute("ADIS_Variable_Associations", varAssoc)
bpIO.DefineAttribute("ADIS_Variable_Sources", varSources)
bpIO.DefineAttribute("ADIS_Variable_Array_Types", arrayTypes)

bpFileWriter = bpIO.Open("xgc-attr.bp", adios2.Mode.Write)
bpFileWriter.Close()
