### Using Data Models Generated by ADIS

ADIS can now generate a data model based on some attributes that are written by ADIOS, instead of requiring the user to write their own data model.
Currently they must be written as Attributes and not Variables, and they can either be written in the same file as your ADIOS data or you could have ADIOS write them in a separate file that contains only the attributes.
If written in separate files, ADIS expects that it is in the same directory as the data to be read.

For each supported data model there is a table of attributes and possible types/values listed below.
If an attribute does not list a default value, it must be specified in the data given to ADIS.

### Setting Fields
ADIS also now supports Wildcard fields which are mostly useful for the data model generation, but can be used in user-created data models as well.
This allows for specifying some basic information about variables in the data model, while allowing the names of the associated variables and their cell/point associations to be specified in ADIOS Attributes.

##### Attributes

| Attribute Name               | Possible types/values                   | Required     |
| --                           | -----                                   | --           |
| `ADIS_Variable_List`         | vector\<string\>: variable names        | yes          |
| `ADIS_Variable_Associations` | vector\<string\>: variable associations | yes          |
| `ADIS_Variable_Sources`      | vector\<string\>: variable data sources | only for XGC |
| `ADIS_Variable_Array_Types`  | vector\<string\>: variable array types  | only for XGC |

##### Example JSON
For most data models, a wildcard field looks like this:

```json
"fields": [
    {
        "variable_list_attribute_name": "ADIS_Variable_List",
        "variable_association_attribute_name": "ADIS_Variable_Associations",
        "array": {
            "array_type": "basic",
            "data_source": "source",
            "variable": ""
        }
    }
]
```
So in your Attributes, you will need an attribute called `ADIS_Variable_List` which is a vector of variable names that you want ADIS to read.
Then the attribute `ADIS_Variable_Associations` is a vector of those variables associations. Each entry should be either `points` or `cell_set`.

For an XGC data model, the field will look like:

```json
"fields": [
    {
        "variable_list_attribute_name": "ADIS_Variable_List",
        "variable_association_attribute_name": "ADIS_Variable_Associations",
        "variable_sources_attribute_name": "ADIS_Variable_Sources",
        "variable_arrays_attribute_name": "ADIS_Variable_Array_Types",
        "array": {
            "array_type": "",
            "data_source": "",
            "variable": ""
        }
    }
]
```
Since XGC has multiple data sources as well as some special handling for certain variables, two additional Attributes are needed.
The attribute `ADIS_Variable_Sources` should have the source name for each variable in `ADIS_Variable_List`.
The value for each entry with be either `mesh` or `3d`, depending on whether the variable is contained in the xgc.mesh.bp or xgc.3d.bp data sets, respectively.
The entries in attribute `ADIS_Variable_Array_Type`, will be `basic` if it's a variable that is for a single plane (e.g., `pot0`) or `xgc_field` if it's for all planes (e.g., `dpot`).

### Supported Data Models

#### Uniform Data Model
The data model uses uniform point coordinates for the coordinate system,
needing the origin and spacing to be specified.
The cell set is structured based on the dimensions of the data.

##### Attributes

| Attribute Name            | Possible types/values                                      | Default |
| --                        | -----                                                      | --      |
| `ADIS_Data_Model`         | string: `uniform`                                          | none    |
| `ADIS_Origin`             | 3 integer or floating points                               | none    |
| `ADIS_Spacing`            | 3 integer or floating points                               | none    |
| `ADIS_Dimension_Variable` | string: name of variable to use for determining dimensions | none    |

##### Example JSON
```json
{
    "uniform_grid": {
        "data_sources": [
            {
                "name": "source",
                "filename_mode": "input"
            }
        ],
        "coordinate_system": {
            "array": {
                "array_type": "uniform_point_coordinates",
                "dimensions": {
                    "source": "variable_dimensions",
                    "data_source": "source",
                    "variable": "density"
                },
                "origin": {
                    "source": "array",
                    "values": [
                        0,
                        0,
                        0
                    ]
                },
                "spacing": {
                    "source": "array",
                    "values": [
                        0.1,
                        0.1,
                        0.1
                    ]
                }
            }
        },
        "cell_set": {
            "cell_set_type": "structured",
            "dimensions": {
                "source": "variable_dimensions",
                "data_source": "source",
                "variable": "density"
            }
        }
    }
}
```


#### Rectilinear Data Model
This data model creates a rectilinear data model where the coordinate system
is specified by a cartesian product of (separate) arrays for the x, y, and z.
The cell set is structured based on the dimensions of the data.

##### Attributes

| Attribute Name            | Possible types/values                                      | Default |
| --                        | -----                                                      | --      |
| `ADIS_Data_Model`         | string: `rectilinear`                                      | none    |
| `ADIS_X_Variable`         | string: name of variable representing x values             | `x`     |
| `ADIS_Y_Variable`         | string: name of variable representing y values             | `y`     |
| `ADIS_Z_Variable`         | string: name of variable representing z values             | `z`     |
| `ADIS_Dimension_Variable` | string: name of variable to use for determining dimensions | none    |

##### Example JSON
```json
{
    "rectilinear_grid": {
        "data_sources": [
            {
                "name": "source",
                "filename_mode": "input"
            }
        ],
        "coordinate_system": {
            "array": {
                "array_type": "cartesian_product",
                "x_array": {
                    "array_type": "basic",
                    "data_source": "source",
                    "variable": "x",
                    "static": true
                },
                "y_array": {
                    "array_type": "basic",
                    "data_source": "source",
                    "variable": "y",
                    "static": true
                },
                "z_array": {
                    "array_type": "basic",
                    "data_source": "source",
                    "variable": "z",
                    "static": true
                }
            }
        },
        "cell_set": {
            "cell_set_type": "structured",
            "dimensions": {
                "source": "variable_dimensions",
                "data_source": "source",
                "variable": "scalars"
            }
        }
    }
}
```

#### Unstructured Data Model

An unstructured or explicit mesh that expects arrays containing the coordinates, connectivity, cell types,
and number of vertices for each cell.

##### Attributes

| Attribute Name               | Possible types/values                                             | Default        |
| --                           | -----                                                             | --             |
| `ADIS_Data_Model`            | string: `unstructured`                                            | none           |
| `ADIS_Coordinates_Variable`  | string: name of variable containing coordinates                   | `points`       |
| `ADIS_Connectivity_Variable` | string: name of connectivity variable                             | `connectivity` |
| `ADIS_Cell_Types_Variable`   | string: name of cell types variable                               | `cell_types`   |
| `ADIS_Num_Vertices_Variable` | string: name of variable listing number of vertices for each cell | `num_verts`    |

##### Example JSON
```json
{
    "unstructured_grid": {
        "data_sources": [
            {
                "name": "source",
                "filename_mode": "input"
            }
        ],
        "coordinate_system": {
            "array": {
                "array_type": "basic",
                "data_source": "source",
                "variable": "points",
                "static": true
            }
        },
        "cell_set": {
            "cell_set_type": "explicit",
            "connectivity": {
                "array_type": "basic",
                "data_source": "source",
                "variable": "connectivity"
            },
            "cell_types": {
                "array_type": "basic",
                "data_source": "source",
                "variable": "cell_types"
            },
            "number_of_vertices": {
                "array_type": "basic",
                "data_source": "source",
                "variable": "num_verts"
            }
        }
    }
}
```

#### Unstructured with Single Cell Type Data Model
Similar to unstructured, except that there is only a single cell type used in the data, so we don't
need to store arrays of the cell types and number of vertices.

##### Attributes

| Attribute Name               | Possible values                                                                                      | Default        |
| --                           | -----                                                                                                | --             |
| `ADIS_Data_Model`            | string: `unstructured_single`                                                                        | none           |
| `ADIS_Cell_Type`             | string: one of `vertex`, `line`, `triangle`, `quad`, `tetrahedron`, `hexahedron`, `wedge`, `pyramid` | none           |
| `ADIS_Coordinates_Variable`  | string: name of variable containing coordinates                                                      | `points`       |
| `ADIS_Connectivity_Variable` | string: name of connectivity variable                                                                | `connectivity` |

##### Example JSON
```json
{
    "unstructured_grid_single_cell_type": {
        "data_sources": [
            {
                "name": "source",
                "filename_mode": "input"
            }
        ],
        "coordinate_system": {
            "array": {
                "array_type": "basic",
                "data_source": "source",
                "variable": "points",
                "static": true
            }
        },
        "cell_set": {
            "cell_set_type": "single_type",
            "cell_type": "triangle",
            "data_source": "source",
            "variable": "connectivity",
            "static": true
        }
    }
}
```

#### XGC Data Model

##### Attributes
| Attribute Name                        | Possible types/values                                           | Default           |
| --                                    | -----                                                           | --                |
| `ADIS_Data_Model`                     | string: `xgc`                                                   |                   |
| `ADIS_XGC_Mesh_Filename`              | string: filename of mesh data (not full path)                   | `xgc.mesh.bp`     |
| `ADIS_XGC_3d_Filename`                | string: filename of 3d data (not full path)                     | `xgc.3d.bp`       |
| `ADIS_Coordinates_Variable`           | string: name of plane coordinates variable                      | `rz`              |
| `ADIS_Triangle_Connectivity_Variable` | string: name of variable containing triangle connectivity       | `nd_connect_list` |
| `ADIS_Plane_Connectivity_Variable`    | string: name of variable containing connectivity between planes | `nextnode`        |
| `ADIS_Number_Of_Planes_Variable`      | string: name of variable for number of planes                   | `nphi`            |

##### Example JSON
```json
{
    "xgc": {
        "data_sources": [
            {
                "name": "mesh",
                "filename_mode": "relative",
                "filename": "xgc.mesh.bp"
            },
            {
                "name": "3d",
                "filename_mode": "relative",
                "filename": "xgc.3d.bp"
            }
        ],
        "coordinate_system": {
            "array": {
                "array_type": "xgc_coordinates",
                "data_source": "mesh",
                "variable": "rz",
                "static": true,
                "is_cylindrical": false
            }
        },
        "cell_set": {
            "cell_set_type": "xgc",
            "periodic": true,
            "cells": {
                "array_type": "basic",
                "data_source": "mesh",
                "variable": "nd_connect_list",
                "static": true,
                "is_vector": "false"
            },
            "plane_connectivity": {
                "array_type": "basic",
                "data_source": "mesh",
                "variable": "nextnode",
                "static": true,
                "is_vector": "false"
            }
        },
        "fields": [
            {
                "variable_list_attribute_name": "ADIS_Variable_List",
                "variable_association_attribute_name": "ADIS_Variable_Associations",
                "variable_sources_attribute_name": "ADIS_Variable_Sources",
                "variable_arrays_attribute_name": "ADIS_Variable_Array_Types",
                "array": {
                    "array_type": "",
                    "data_source": "",
                    "variable": ""
                }
            }
        ],
        "number_of_planes": {
            "source": "scalar",
            "data_source": "3d",
            "variable": "nphi"
        }
    }
}
```
