#!/bin/sh

# VTK-m master - Jul 16, 2020
VTKM_HASH=502c310cf891ea27283641bae38d999bdb43fb5f
VTKM_SHORT_HASH=${VTKM_HASH:0:8}

# ADIOS2 master - Apr 13, 2020
ADIOS_HASH=3324c77f95f9b0a17ffc67b7186985b3e19a6ed3
ADIOS_SHORT_HASH=${ADIOS_HASH:0:8}

cp install_cmake.sh ubuntu18
cp install_adios2.sh ubuntu18
cp install_vtkm.sh ubuntu18
IMAGE_NAME=kitware/vtk:ci-adis-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}-latest
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  --build-arg ADIOS_HASH=$ADIOS_HASH \
  -t $IMAGE_NAME \
  ubuntu18/
rm ubuntu18/install_adios2.sh
rm ubuntu18/install_vtkm.sh
rm ubuntu18/install_cmake.sh
docker push $IMAGE_NAME

cp install_cmake.sh ubuntu18-ompi
cp install_adios2.sh ubuntu18-ompi
cp install_vtkm.sh ubuntu18-ompi
IMAGE_NAME=kitware/vtk:ci-adis-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}-ompi-latest
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  --build-arg ADIOS_HASH=$ADIOS_HASH \
  -t $IMAGE_NAME \
  ubuntu18-ompi/
rm ubuntu18-ompi/install_adios2.sh
rm ubuntu18-ompi/install_vtkm.sh
rm ubuntu18-ompi/install_cmake.sh
docker push $IMAGE_NAME

#edit names in .gitlab-ci.yml
sed -i '' -e "s/ci-adis-vtkm[a-zA-Z0-9]\{8\}-adios[a-zA-Z0-9]\{8\}/ci-adis-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}/g" ../../../.gitlab-ci.yml
