

#include <adis/xgc/ArrayHandleXGCPointCoordinates.h>
#include <adis/xgc/PointsXGC.hxx>

#include <vtkm/cont/serial/DeviceAdapterSerial.h>
#include <vtkm/cont/tbb/DeviceAdapterTBB.h>
#include <vtkm/exec/ConnectivityExtrude.h>

#if defined(VTKM_GCC)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wattributes"
#endif

//instantiate the template class
//exports for the ArrayPortalPointsXGC and Connectivity
namespace vtkm
{
namespace exec
{
template struct
    ArrayPortalPointsXGC<cont::internal::ArrayPortalFromIterators<float const *, void>>;
template struct
    ArrayPortalPointsXGC<cont::internal::ArrayPortalFromIterators<double const *, void>>;

} // namespace exec
} // namespace vtkm

//exports for the ArrayHandleXGCPointCoordinates
namespace vtkm
{
namespace cont
{
template class ArrayHandleXGCPointCoordinates<float>;
template class ArrayHandleXGCPointCoordinates<double>;
} // namespace cont
} // namespace vtkm

//exports for the ArrayHandle<T, StorageTagPointsXGC> internal implementation
namespace vtkm
{
namespace cont
{
namespace internal
{
template class Storage<vtkm::Vec<float, 3>, StorageTagPointsXGC>;
template class Storage<vtkm::Vec<double, 3>, StorageTagPointsXGC>;
template class
    ArrayHandleExecutionManagerBase<vtkm::Vec<float, 3>, StorageTagPointsXGC>;
template class
    ArrayHandleExecutionManagerBase<vtkm::Vec<double, 3>, StorageTagPointsXGC>;

template class
    ArrayTransfer<vtkm::Vec<float, 3>, StorageTagPointsXGC, DeviceAdapterTagSerial>;
template class
    ArrayTransfer<vtkm::Vec<double, 3>, StorageTagPointsXGC, DeviceAdapterTagSerial>;
template class
    ArrayHandleExecutionManager<vtkm::Vec<float, 3>, StorageTagPointsXGC, DeviceAdapterTagSerial>;
template class
    ArrayHandleExecutionManager<vtkm::Vec<double, 3>, StorageTagPointsXGC, DeviceAdapterTagSerial>;

#ifdef VTKM_ENABLE_TBB
template class
    ArrayTransfer<vtkm::Vec<float, 3>, StorageTagPointsXGC, DeviceAdapterTagTBB>;
template class
    ArrayTransfer<vtkm::Vec<double, 3>, StorageTagPointsXGC, DeviceAdapterTagTBB>;
template class
    ArrayHandleExecutionManager<vtkm::Vec<float, 3>, StorageTagPointsXGC, DeviceAdapterTagTBB>;
template class
    ArrayHandleExecutionManager<vtkm::Vec<double, 3>, StorageTagPointsXGC, DeviceAdapterTagTBB>;
#endif
} // namespace internal
} // namespace cont
} // namespace vtkm

#if defined(VTKM_GCC)
#pragma GCC diagnostic pop
#endif
