#ifndef adis_xgc_ArrayHandleXGCPointCoordinates_h
#define adis_xgc_ArrayHandleXGCPointCoordinates_h

#include <adis/xgc/PointsXGC.h>
#include <adis/xgc/PointsXGC.hxx>

#include <vtkm/cont/ArrayHandle.h>
#include <vtkm/cont/CoordinateSystem.h>
#include <vtkm/cont/CoordinateSystem.hxx>

namespace vtkm
{
namespace cont
{

template <typename T>
class  ArrayHandleXGCPointCoordinates
  : public vtkm::cont::ArrayHandle<vtkm::Vec<T, 3>, internal::StorageTagPointsXGC>
{

  using StorageType = vtkm::cont::internal::Storage<vtkm::Vec<T, 3>, internal::StorageTagPointsXGC>;

public:
  VTKM_ARRAY_HANDLE_SUBCLASS(
    ArrayHandleXGCPointCoordinates,
    (ArrayHandleXGCPointCoordinates<T>),
    (vtkm::cont::ArrayHandle<vtkm::Vec<T, 3>, internal::StorageTagPointsXGC>));

  ArrayHandleXGCPointCoordinates(const StorageType& storage)
    : Superclass(storage)
  {
  }

  vtkm::Int32 GetNumberOfPointsPerPlane() const { return (this->GetStorage().Length/2); }
  vtkm::Int32 GetNumberOfPlanes() const { return this->GetStorage().NumberOfPlanes; }
};

template <typename T>
vtkm::cont::ArrayHandleXGCPointCoordinates<T>
make_ArrayHandleXGCPointCoordinates(const T* array,
                                    vtkm::Id length,
                                    vtkm::Int32 numberOfPlanes,
                                    bool cylindrical,
                                    vtkm::CopyFlag copy = vtkm::CopyFlag::Off)
{
  using StorageType = vtkm::cont::internal::Storage<vtkm::Vec<T, 3>, internal::StorageTagPointsXGC>;
  if (copy == vtkm::CopyFlag::Off)
  {
    return ArrayHandleXGCPointCoordinates<T>(StorageType(array, length, numberOfPlanes, cylindrical));
  }
  else
  {
    auto storage = StorageType(vtkm::cont::make_ArrayHandle(array, length, vtkm::CopyFlag::On),
                               numberOfPlanes,
                               cylindrical);
    return ArrayHandleXGCPointCoordinates<T>(storage);
  }
}

template <typename T>
vtkm::cont::ArrayHandleXGCPointCoordinates<T> make_ArrayHandleXGCPointCoordinates(
  const std::vector<T>& array,
  vtkm::Int32 numberOfPlanes,
  bool cylindrical,
  vtkm::CopyFlag copy = vtkm::CopyFlag::Off)
{
  if (!array.empty())
  {
    return make_ArrayHandleXGCPointCoordinates(
      &array.front(), static_cast<vtkm::Id>(array.size()), numberOfPlanes, cylindrical, copy);
  }
  else
  {
    // Vector empty. Just return an empty array handle.
    return ArrayHandleXGCPointCoordinates<T>();
  }
}

}
}

// template classes we want to compile only once
namespace vtkm { namespace cont {

extern template class ArrayHandleXGCPointCoordinates<float>;
extern template class ArrayHandleXGCPointCoordinates<double>;
} }

#endif
