
#ifndef adis_xgc_ArrayHandleXGCFieldPlane_h
#define adis_xgc_ArrayHandleXGCFieldPlane_h


#include <adis/xgc/FieldXGCPlane.h>
#include <vtkm/cont/ArrayHandle.h>

namespace vtkm
{
namespace cont
{

template <typename T>
class VTKM_ALWAYS_EXPORT ArrayHandleXGCFieldPlane
  : public vtkm::cont::ArrayHandle<T, internal::StorageTagFieldXGCPlane>
{
  using HandleType = vtkm::cont::ArrayHandle<T>;
  using StorageType = vtkm::cont::internal::Storage<T, internal::StorageTagFieldXGCPlane>;

public:
  VTKM_ARRAY_HANDLE_SUBCLASS(
    ArrayHandleXGCFieldPlane,
    (ArrayHandleXGCFieldPlane<T>),
    (vtkm::cont::ArrayHandle<T, internal::StorageTagFieldXGCPlane>));

  ArrayHandleXGCFieldPlane(const StorageType& storage)
    : Superclass(storage)
  {
  }

  vtkm::Id GetNumberOfValuesPerPlane() const
  {
    return this->GetStorage().GetNumberOfValuesPerPlane();
  }

  vtkm::Id GetNumberOfPlanes() const
  {
    return this->GetStorage().GetNumberOfPlanes();
  }
};

template <typename T>
vtkm::cont::ArrayHandleXGCFieldPlane<T>
make_ArrayHandleXGCFieldPlane(const std::vector<vtkm::cont::ArrayHandle<T> > arrays,
  vtkm::Id numPlanes, vtkm::Id blocksPerPlane,
  vtkm::CopyFlag copy = vtkm::CopyFlag::Off)
{
  using StorageType = vtkm::cont::internal::Storage<T, internal::StorageTagFieldXGCPlane>;
  auto storage = StorageType(arrays, numPlanes, blocksPerPlane);
  return ArrayHandleXGCFieldPlane<T>(storage);
}

}
} // vtkm::cont

#endif
