#!/bin/sh

cd /tmp
mkdir -p Software

# Install VTK-m
cd /tmp/Software
git clone -n https://gitlab.kitware.com/vtk/vtk-m.git
cd vtk-m
# master - Sep 5, 2019
git checkout 64ad158124a0c0c720143b5286719327cc64c130
cd ..
mkdir -p vtkm-build
cd vtkm-build
cmake -GNinja \
    -DCMAKE_INSTALL_PREFIX=/opt/vtkm \
    -DBUILD_SHARED_LIBS=ON \
    -DCMAKE_BUILD_TYPE=Release \
    -DVTKm_ENABLE_TESTING=OFF \
    ../vtk-m
ninja
ninja install

# Install ADIOS2
cd /tmp/Software
git clone https://github.com/ornladios/ADIOS2.git --single-branch --branch v2.5.0 --depth 1
mkdir -p ADIOS2-build
cd ADIOS2-build
cmake -GNinja \
    -DCMAKE_INSTALL_PREFIX=/opt/adios2 \
    -DADIOS2_BUILD_TESTING=OFF \
    -DADIOS2_BUILD_EXAMPLES=OFF \
    -DADIOS2_USE_Endian_Reverse=ON \
    ../ADIOS2
ninja
ninja install

cd /tmp
rm -fr Software/
