/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.web3d.util.KeyedWeakReference;

public class WeakValueHashMap
implements Map {
    private ReferenceQueue theReferenceQueue;
    private HashMap internalHashMap;

    public WeakValueHashMap() {
        this.internalHashMap = new HashMap();
        this.theReferenceQueue = new ReferenceQueue();
    }

    public WeakValueHashMap(int n) {
        this.internalHashMap = new HashMap(n);
        this.theReferenceQueue = new ReferenceQueue();
    }

    public void clear() {
        this.theReferenceQueue = new ReferenceQueue();
        this.internalHashMap.clear();
    }

    public boolean containsKey(Object object) {
        return this.internalHashMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    protected void flushEmptyReferences() {
        KeyedWeakReference keyedWeakReference = (KeyedWeakReference)this.theReferenceQueue.poll();
        while (keyedWeakReference != null) {
            this.internalHashMap.remove(keyedWeakReference.key());
            keyedWeakReference = (KeyedWeakReference)this.theReferenceQueue.poll();
        }
    }

    public Object get(Object object) {
        this.flushEmptyReferences();
        WeakReference weakReference = (WeakReference)this.internalHashMap.get(object);
        if (weakReference != null) {
            Object t = weakReference.get();
            if (t == null) {
                this.internalHashMap.remove(object);
            }
            return t;
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isEmpty() {
        return this.internalHashMap.isEmpty();
    }

    public Set keySet() {
        return this.internalHashMap.keySet();
    }

    public Object put(Object object, Object object2) {
        if (object2 == null || object == null) {
            throw new IllegalArgumentException();
        }
        this.flushEmptyReferences();
        KeyedWeakReference keyedWeakReference = new KeyedWeakReference(object, object2, this.theReferenceQueue);
        KeyedWeakReference keyedWeakReference2 = this.internalHashMap.put(object, keyedWeakReference);
        if (keyedWeakReference2 != null) {
            return keyedWeakReference2.get();
        }
        return null;
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        KeyedWeakReference keyedWeakReference = (KeyedWeakReference)this.internalHashMap.remove(object);
        if (keyedWeakReference != null) {
            return keyedWeakReference.get();
        }
        return null;
    }

    public int size() {
        return this.internalHashMap.size();
    }

    public Collection values() {
        this.flushEmptyReferences();
        Vector vector = new Vector();
        for (WeakReference weakReference : this.internalHashMap.values()) {
            Object t = weakReference.get();
            if (t == null) continue;
            vector.add(t);
        }
        return vector;
    }
}

