/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.BaseEmitter;
import org.j3d.geom.particle.Particle;

public class PointEmitter
extends BaseEmitter {
    private static final int DELTA_LIMIT = 5;
    private float particlesPerMs;
    private float[] origin;
    private float force;
    private float[] initialVelocity;
    private float[] direction;
    private int zeroDeltaCounter;
    private int elapsedZeroParticleTime;

    public PointEmitter() {
        this.origin = new float[3];
        this.initialVelocity = new float[3];
        this.direction = new float[3];
        this.direction[1] = 1.0f;
        this.elapsedZeroParticleTime = 0;
    }

    public PointEmitter(int n, int n2, float[] fArray, float[] fArray2, float[] fArray3, float f, float f2) {
        super(n, n2, fArray3, f, f2);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
        this.elapsedZeroParticleTime = 0;
        this.origin = new float[3];
        this.origin[0] = fArray[0];
        this.origin[1] = fArray[1];
        this.origin[2] = fArray[2];
        this.initialVelocity = new float[3];
        this.initialVelocity[0] = fArray2[0] * f;
        this.initialVelocity[1] = fArray2[1] * f;
        this.initialVelocity[2] = fArray2[2] * f;
        this.direction = new float[3];
        float f3 = fArray2[0] * fArray2[0] + fArray2[1] * fArray2[1] + fArray2[2] * fArray2[2];
        if (f3 != 0.0f) {
            f3 = 1.0f / f3;
            this.direction[0] = f3 * fArray2[0];
            this.direction[1] = f3 * fArray2[1];
            this.direction[2] = f3 * fArray2[2];
        }
    }

    public void setMaxParticleCount(int n) {
        super.setMaxParticleCount(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public void setParticleLifetime(int n) throws IllegalArgumentException {
        super.setParticleLifetime(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = (int)(this.particlesPerMs * (float)n);
                if (n2 != 0) break;
                this.elapsedZeroParticleTime += n;
                n2 = (int)(this.particlesPerMs * (float)this.elapsedZeroParticleTime);
                if (n2 == 0) break;
                this.elapsedZeroParticleTime = 0;
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        float f = 1.0f - (float)Math.random() * this.variation;
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3] * f);
        f = 1.0f - (float)Math.random() * this.lifetimeVariation;
        particle.setCycleTime((int)((float)this.lifetime * f));
        particle.setPosition(this.origin[0], this.origin[1], this.origin[2]);
        particle.setMass(this.initialMass);
        particle.setSurfaceArea(this.surfaceArea);
        f = 1.0f - this.randomiser.nextFloat() * this.variation;
        float f2 = this.initialVelocity[0] * f;
        float f3 = this.initialVelocity[1] * f;
        float f4 = this.initialVelocity[2] * f;
        particle.velocity.set(f2, f3, f4);
        return true;
    }

    public void setPosition(float f, float f2, float f3) {
        this.origin[0] = f;
        this.origin[1] = f2;
        this.origin[2] = f3;
    }

    public void setSpeed(float f) {
        super.setSpeed(f);
        this.initialVelocity[0] = this.direction[0] * f;
        this.initialVelocity[1] = this.direction[1] * f;
        this.initialVelocity[2] = this.direction[2] * f;
    }

    public void setDirection(float f, float f2, float f3) {
        float f4 = f * f + f2 * f2 + f3 * f3;
        if (f4 != 0.0f) {
            f4 = 1.0f / f4;
            f *= f4;
            f2 *= f4;
            f3 *= f4;
        }
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
        this.initialVelocity[0] = f * this.speed;
        this.initialVelocity[1] = f2 * this.speed;
        this.initialVelocity[2] = f3 * this.speed;
    }
}

