/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import org.j3d.util.interpolator.Interpolator;

public class BooleanInterpolator
extends Interpolator {
    private boolean[] keyValues;

    public BooleanInterpolator() {
        this(20, 1);
    }

    public BooleanInterpolator(int n) {
        this(n, 2);
    }

    public BooleanInterpolator(int n, int n2) {
        super(n, n2);
        this.keyValues = new boolean[n];
    }

    public void addKeyFrame(float f, boolean bl) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            n = 0;
        }
        while (n < this.currentSize && this.keys[n] <= f) {
            ++n;
        }
        this.realloc();
        if (n >= this.currentSize) {
            this.keyValues[this.currentSize] = bl;
        } else {
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            this.keyValues[n] = bl;
        }
        this.keys[n] = f;
        ++this.currentSize;
    }

    public boolean booleanValue(float f) {
        boolean bl;
        int n = this.findKeyIndex(f);
        if (n < 0) {
            bl = this.keyValues[0];
        } else if (n >= this.currentSize - 1) {
            bl = this.keyValues[this.currentSize - 1];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    boolean bl2 = this.keyValues[n + 1];
                    boolean bl3 = this.keyValues[n];
                    float f2 = 0.0f;
                    float f3 = this.keys[n];
                    float f4 = this.keys[n + 1];
                    if (f4 != f3) {
                        f2 = (f - f3) / (f4 - f3);
                    }
                    if ((double)f2 <= 0.5) {
                        bl = bl3;
                        break;
                    }
                    bl = bl2;
                    break;
                }
                case 2: {
                    bl = this.keyValues[n];
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.keyValues, 0, blArray, 0, this.allocatedSize);
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = blArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<boolean interpolator>\n");
        for (int i = 0; i < this.currentSize; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(" value: ");
            stringBuffer.append(this.keyValues[i]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</boolean interpolator>");
        return stringBuffer.toString();
    }
}

