//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME smtkRGGEditPinView - UI component for Edit RGG pins
// .SECTION Description
// .SECTION See Also
// qtSection

#ifndef smtkRGGEditPinView_h
#define smtkRGGEditPinView_h

#include "smtk/extension/qt/qtOperationView.h"
#include "smtk/session/rgg/Pin.h"
#include "smtk/session/rgg/plugin/Exports.h"

class QColor;
class QComboBox;
class QIcon;
namespace smtk
{
namespace extension
{
class qtItem;
}
}

class smtkRGGEditPinViewInternals;

class smtkRGGEditPinView : public smtk::extension::qtBaseAttributeView
{
  Q_OBJECT

public:
  smtkTypenameMacro(smtkRGGEditPinView);
  smtkRGGEditPinView(const smtk::extension::OperationViewInfo& info);
  virtual ~smtkRGGEditPinView() override;

  static smtk::extension::qtBaseView* createViewWidget(const smtk::extension::ViewInfo& info);

public slots:
  void requestModelEntityAssociation() override;
  void onShowCategory() override { this->updateUI(); }
  void valueChanged(smtk::attribute::ItemPtr optype) override;

protected slots:
  virtual void requestOperation(const smtk::operation::OperationPtr& op);

  // This slot is used to indicate that the underlying attribute
  // for the operation should be checked for validity
  virtual void attributeModified();
  void onAttItemModified(smtk::extension::qtItem* item);
  void apply();

  // UI related slots
  void pieceTypeChanged();

protected:
  void updateUI() override;
  void createWidget() override;
  // When the association has been modified, this function would populate the edit pin
  // panel
  void updateEditPinPanel();
  virtual void setInfoToBeDisplayed() override;
  // Helper functions for createWidget
  void createPiecesTable();
  void addPieceToTable(
    int row, smtk::session::rgg::Pin::PieceType type, double height, double baseR, double topR);
  void createLayersTable();
  void addlayerBefore();
  void addlayerAfter();
  void deletelayer();

  void addLayerToTable(int row, int subMaterial, double rN);
  void updateButtonStatus();
  void setupMaterialComboBox(QComboBox* box, bool isCell = false);

private:
  smtkRGGEditPinViewInternals* Internals;
};

#endif // smtkRGGEditPinView_h
