/*============================================================================
  CMake - Cross Platform Makefile Generator
  Copyright 2000-2009 Kitware, Inc., Insight Software Consortium

  Distributed under the OSI-approved BSD License (the "License");
  see accompanying file Copyright.txt for details.

  This software is distributed WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the License for more information.
============================================================================*/
#ifndef cmIncludeExternalMSProjectCommand_h
#define cmIncludeExternalMSProjectCommand_h

#include "cmCommand.h"

/** \class cmIncludeExternalMSProjectCommand
 * \brief Specify an external MS project file for inclusion in the workspace.
 *
 * cmIncludeExternalMSProjectCommand is used to specify an externally
 * generated Microsoft project file for inclusion in the default workspace
 * generated by CMake.
 */
class cmIncludeExternalMSProjectCommand : public cmCommand
{
public:
  /**
   * This is a virtual constructor for the command.
   */
  virtual cmCommand* Clone()
    {
    return new cmIncludeExternalMSProjectCommand;
    }

  /**
   * This is called when the command is first encountered in
   * the CMakeLists.txt file.
   */
  virtual bool InitialPass(std::vector<std::string> const& args,
                           cmExecutionStatus &status);

  /**
   * The name of the command as specified in CMakeList.txt.
   */
  virtual const char* GetName() const {return "include_external_msproject";}

  cmTypeMacro(cmIncludeExternalMSProjectCommand, cmCommand);
};



#endif
