'''
Separate file for the text blocks to be formatted.
These strings will be formatted in generator.py, then used to
generate valid pybind11 binding code
'''


cppbody = """
#include "pybind11/operators.h"
#include "pybind11/pybind11.h"
#include "pybind11/stl.h"
{includes}


namespace py = pybind11;
//#include "drake/bindings/pydrake/documentation_pybind.h"
//#include "drake/bindings/pydrake/pydrake_pybind.h"

// namespace drake {{
// namespace pydrake {{
PYBIND11_MODULE({name}, m)
{{
  py::class_<{pyclass_args}>(m, "{name}"{doc})
    {constructor}
    {funcs}
    {vars}
    {arith}
    ;
}}

// }}  // namespace pydrake
// }}  // namespace drake
"""

arithmetic = """
  // Arithmetic
  .def(-py::self)
  .def(py::self + py::self)
  .def(py::self + {type}())
  .def({type}() + py::self)
  .def(py::self - py::self)
  .def(py::self - {type}())
  .def({type}() - py::self)
  .def(py::self * py::self)
  .def(py::self * {type}())
  .def({type}() * py::self)
  .def(py::self / {type}())
  // Logical comparison
  .def(py::self == py::self);

"""
module_cpp = """
#include <pybind11/pybind11.h>
{includes}
namespace py = pybind11;

PYBIND11_MODULE(_{namespace}_funcs, m)
{{
  {defs}
}}
"""
member_func = """{module}.def{static}(\"{fun_name}\", {fun_ref}, {args}{doc}){ending}\n"""

constructor = """.def(py::init<{}>(){})\n"""
member_func_arg = """ py::arg(\"{}\") {}"""
member_var_fmt = """.def_read{write}{static}(\"{var_name}\", &{classname}::{var_name})\n"""
overload_template = """({decl_string}) ({fun_ref})"""
wrap_header = """#ifndef TMP_WRAPPING_HEADER
#define TMP_WRAPPING_HEADER
%s
%s
namespace _wrapping_
{
  const char* const group = "%s";

  namespace wrappers
  {
    %s
  }

  void force_instantiate()
  {
    using namespace _wrapping_::wrappers;
  }
}
#endif
"""