//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//============================================================================

#include "DataSetReader.h"

#include <mpi.h>
#include <string>
#include <unordered_map>
#include <vector>

#include <vtkm/cont/Algorithm.h>
#include <vtkm/cont/CoordinateSystem.hxx>
#include <vtkm/worklet/DispatcherMapTopology.h>
#include <vtkm/worklet/WorkletMapTopology.h>
#include <vtkm/worklet/ScatterPermutation.h>

int main(int argc, char** argv)
{
  MPI_Init(&argc, &argv);

  int retVal = 0;
  adis::io::DataSetReader reader(argv[1]);
  std::unordered_map<std::string, std::string> paths;
  paths["the-source"] = std::string(argv[2]) + "/xgc.mesh.bp";

  auto metaData = reader.ReadMetaData(paths);
  vtkm::cont::MultiBlock output = reader.ReadDataSet(
    paths, adis::metadata::MetaData());

  MPI_Finalize();
  return retVal;
}
