//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//============================================================================

#include "DataSetReader.h"

#include <mpi.h>
#include <string>
#include <unordered_map>
#include <vector>

#include <vtkm/cont/Algorithm.h>
#include <vtkm/cont/CoordinateSystem.hxx>
#include <vtkm/worklet/DispatcherMapTopology.h>
#include <vtkm/worklet/WorkletMapTopology.h>
#include <vtkm/worklet/ScatterPermutation.h>

int main(int argc, char** argv)
{
  MPI_Init(&argc, &argv);

  int retVal = 0;
  adis::io::DataSetReader reader(argv[1]);
  std::unordered_map<std::string, std::string> paths;
  paths["the-source"] = std::string(argv[2]) + "/cartesian.bp";

  auto metaData = reader.ReadMetaData(paths);

  vtkm::cont::MultiBlock output = reader.ReadDataSet(
    paths, adis::metadata::MetaData());
  if (output.GetNumberOfBlocks() != 2)
  {
    std::cerr << "Error: expected 2 output blocks, got " << output.GetNumberOfBlocks() << std::endl;
    retVal = 1;
  }
  vtkm::cont::DataSet ds = output.GetBlock(0);
  vtkm::cont::DynamicCellSet cellSet = ds.GetCellSet();
  vtkm::cont::CellSetStructured<3> css = cellSet.Cast<
    vtkm::cont::CellSetStructured<3> >();
  auto dims = css.GetPointDimensions();
  std::cout << dims[0] << " " << dims[1] << " " << dims[2] << std::endl;

  MPI_Finalize();
  return retVal;
}
