//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//============================================================================

#include "CoordinateSystem.h"

#include <vtkm/cont/CoordinateSystem.hxx>

#include "rapidjson/stringbuffer.h"
#include <rapidjson/writer.h>
namespace adis
{
namespace datamodel
{

void CoordinateSystem::ProcessJSON(const rapidjson::Value& json,
                                   DataSourcesType& sources)
{
  std::cout<<__FILE__<<" "<<__LINE__<<std::endl;

  rapidjson::StringBuffer buffer;
  buffer.Clear();
  rapidjson::Writer<rapidjson::StringBuffer> writer(buffer);
  json.Accept(writer);
  std::cout<<"JSON: "<<buffer.GetString()<<std::endl;
  std::cout<<"val= "<<json.HasMember("variable")<<std::endl;
  std::cout<<"val= "<<json.HasMember("data_source")<<std::endl;
  std::cout<<"val0= "<<json["variable"].IsString()<<std::endl;

  this->Array.reset();
  //Cartesian coordinates
  if (json.HasMember("array") && json["array"].IsObject())
  {
    this->Array = std::make_shared<adis::datamodel::Array>();
    this->Array->ObjectName = "array";
    this->Array->ProcessJSON(json["array"], sources);
  }
  //Explicit coordinates.
  else if (json.HasMember("variable") && json["variable"].IsString())
  {
    std::cout<<"Make explicit coordinates...."<<std::endl;
    this->Array = std::make_shared<adis::datamodel::Array>();
    this->Array->ObjectName = "points";
    this->Array->ProcessJSON(json["points"], sources);
  }
  else
    throw std::runtime_error(this->ObjectName  + " contains insufficient information.");
}

size_t CoordinateSystem::GetNumberOfBlocks(
  const std::unordered_map<std::string, std::string>& paths,
  DataSourcesType& sources)
{
  return this->Array->GetNumberOfBlocks(paths, sources);
}

std::vector<vtkm::cont::CoordinateSystem> CoordinateSystem::Read(
  const std::unordered_map<std::string, std::string>& paths,
  DataSourcesType& sources,
  const adis::metadata::MetaData& selections)
{
  using CoordinateStorageTypes =
    vtkm::ListTagBase<vtkm::cont::ArrayHandleUniformPointCoordinates::StorageTag,
                      vtkm::cont::StorageTagBasic>;
  // using VecType = vtkm::Vec<float, 3>;
  std::vector<vtkm::cont::VariantArrayHandle> arrays =
    this->Array->Read(paths, sources, selections);
  std::vector<vtkm::cont::CoordinateSystem> coordSystems;
  // coordSystems.reserve(arrays.size());
  // using CoordsHandleType = vtkm::cont::ArrayHandle<VecType>;
  for(auto& array : arrays)
  {
    // auto expandedTypeArray = array.ResetStorageList(CoordinateStorageTypes{});
    // CoordsHandleType coordsHandle = array.Cast<CoordsHandleType>();
    // coordSystems.push_back(
    //   vtkm::cont::CoordinateSystem("coordinates", coordsHandle));
    coordSystems.push_back(
      vtkm::cont::CoordinateSystem("coordinates", array));
  }
  return coordSystems;
}

}
}
