# ADIS - Adaptive Data Interfaces and Services

ADIS is a library for seamless interoperability of ADIOS2 and VTK-m.

## Compilation

The required dependencies of ADIS are MPI, [VTK-m](https://gitlab.kitware.com/vtk/vtk-m), [ADIOS2](https://github.com/ornladios/ADIOS2/), and [RapidJSON](https://github.com/Tencent/rapidjson/).

Once the dependencies are installed, the compilation of ADIS is idiomatic:

```bash
$ git clone https://gitlab.kitware.com/vtk/adis
$ mkdir build_adis && cd build_adis
build_adis$ cmake ../adis
build_adis$ make -j 16
```

If you want to hack on ADIS, you'll need to do a bit more.
First, you'll need to install [Git Large File Storage](https://git-lfs.github.com/).

Then

```bash
adis$ git lfs install
adis$ git lfs pull
```

Now the test data should be present:

```bash
adis$ ls tests/data/
cartesian.bp      tris-blocks.bp         tris-blocks-fields.bp.dir  tris-blocks-time.bp      tris.bp.dir
cartesian.bp.dir  tris-blocks.bp.dir     tris-blocks-mesh.bp        tris-blocks-time.bp.dir
multicomb_0.vts   tris-blocks-fields.bp  tris-blocks-mesh.bp.dir    tris.bp
```

Then build ADIS with developer options:

```bash
build_adis$ cmake -DADIS_ENABLE_TESTING=ON -DCMAKE_BUILD_TYPE=Debug ../adis
build_adis$ make -j 16
```

The tests are managed via `ctest`, so after successful compilation

```bash
build_adis$ ctest -V
```

We have used the same `.clang-format` file as `VTK-m`, and hence please use it before checkin:

```bash
adis$ clang-format -style=file -i ChangedFile.cxx
```
