/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.16u-20021018-1459
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    inline SwigValueWrapper() : tt(0) { }
    inline ~SwigValueWrapper() { if (tt) delete tt; } 
    inline SwigValueWrapper& operator=(const T& t) { tt = new T(t); return *this; }
    inline operator T&() const { return *tt; }
    inline T *operator&() { return tt; }
};                                                    
#endif


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;

#if defined(SWIG_NOINCLUDE)
void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg);
#else


void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


#endif


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz;
  sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <XdmfObject.h>
#include <XdmfCharArray.h>
#include <XdmfAttribute.h>
#include <XdmfDOM.h>
#include <XdmfArray.h>
#include <XdmfHDFSupport.h>
#include <XdmfFormat.h>
#include <XdmfFormatMulti.h>
#include <XdmfFormatXML.h>
#include <XdmfFormatHDF.h>
#include <XdmfGeometry.h>
#include <XdmfGrid.h>
#include <XdmfLightData.h>
#include <XdmfHeavyData.h>
#include <XdmfHDF.h>
#include <XdmfDataDesc.h>
#include <XdmfXNode.h>
#include <XdmfExpression.h>
#include <XdmfTransform.h>
#include <XdmfTopology.h>
#include <XdmfParameter.h>
#ifdef HAVE_NDGM
#include <XdmfNDGM.h>
#endif

extern void SetGlobalDebugOn();
extern void SetGlobalDebugOff();
extern XdmfInt32 GetGlobalDebug(void);
extern void SetGlobalDebug(XdmfInt32);
extern XdmfString GetUnique(XdmfString);
extern char *XdmfObjectToHandle(XdmfObject *);
extern XdmfObject *HandleToXdmfObject(char *);
extern hid_t XdmfTypeToHDF5Type(XdmfInt32);
extern XdmfInt32 HDF5TypeToXdmfType(hid_t);
extern XdmfString XdmfTypeToString(XdmfInt32);
extern XdmfInt32 StringToXdmfType(XdmfString);
extern XdmfString XdmfTypeToClassString(XdmfInt32);
extern XdmfArray *TagNameToArray(XdmfString);
extern void PrintAllXdmfArrays(void);
extern XdmfArray *GetNextOlderArray(XdmfLength,XdmfLength *);
extern XdmfLength GetCurrentArrayTime(void);
extern XdmfArray *CopyArray(XdmfArray *,XdmfArray *);
extern int GetXNodeSize(XdmfXNode *);
extern char *GetXNodeName(XdmfXNode *,int);
extern char *GetXNodeData(XdmfXNode *,int);
extern XdmfTopology *HandleToXdmfTopology(char *);
extern XdmfGeometry *GetXdmfGeometryHandle(void *);
extern XdmfGrid *HandleToXdmfGrid(char *);
#ifdef __cplusplus
extern "C" {
#endif
JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1SUCCESS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1FAIL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) -1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1TRUE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1FALSE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1MAX_1DIMENSION(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1MAX_1STRING_1LENGTH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1DEFAULT_1INDEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) -1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1SELECT_1SLAB(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1SELECT_1INDEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1INT8_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1INT32_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1INT64_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1FLOAT32_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1FLOAT64_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1COMPOUND_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfObject(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfObject *result;
    
    result = (XdmfObject *)new XdmfObject();
    
    *(XdmfObject **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    
    arg1 = *(XdmfObject **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfObject_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    char *result;
    
    arg1 = *(XdmfObject **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfObject_1SetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    XdmfBoolean arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfObject **)&jarg1; 
    arg2 = (XdmfBoolean)jarg2; 
    result = (XdmfInt32)(arg1)->SetDebug(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfObject_1GetDebug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    XdmfBoolean result;
    
    arg1 = *(XdmfObject **)&jarg1; 
    result = (XdmfBoolean)(arg1)->GetDebug();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfObject_1GetGlobalDebug(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    XdmfBoolean result;
    
    arg1 = *(XdmfObject **)&jarg1; 
    result = (XdmfBoolean)(arg1)->GetGlobalDebug();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfObject_1SetGlobalDebug(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    XdmfBoolean arg2 ;
    
    arg1 = *(XdmfObject **)&jarg1; 
    arg2 = (XdmfBoolean)jarg2; 
    (arg1)->SetGlobalDebug(arg2);
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfObject_1SetGlobalDebugOn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    
    arg1 = *(XdmfObject **)&jarg1; 
    (arg1)->SetGlobalDebugOn();
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfObject_1SetGlobalDebugOff(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    
    arg1 = *(XdmfObject **)&jarg1; 
    (arg1)->SetGlobalDebugOff();
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_SetGlobalDebugOn(JNIEnv *jenv, jclass jcls) {
    SetGlobalDebugOn();
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_SetGlobalDebugOff(JNIEnv *jenv, jclass jcls) {
    SetGlobalDebugOff();
    
}


JNIEXPORT jint JNICALL Java_XdmfJNI_GetGlobalDebug(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    XdmfInt32 result;
    
    result = (XdmfInt32)GetGlobalDebug();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_SetGlobalDebug(JNIEnv *jenv, jclass jcls, jint jarg1) {
    XdmfInt32 arg1 ;
    
    arg1 = (XdmfInt32)jarg1; 
    SetGlobalDebug(arg1);
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_GetUnique(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jstring jresult = 0 ;
    XdmfString arg1 = (XdmfString) NULL ;
    XdmfString result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (XdmfString)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfString)GetUnique(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfObjectToHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfObject *arg1 = (XdmfObject *) 0 ;
    char *result;
    
    arg1 = *(XdmfObject **)&jarg1; 
    result = (char *)XdmfObjectToHandle(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_HandleToXdmfObject(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    XdmfObject *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfObject *)HandleToXdmfObject(arg1);
    
    *(XdmfObject **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1PARAMETER_1RANGE_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1PARAMETER_1LIST_1TYPE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTypeToHDF5Type(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    XdmfInt32 arg1 ;
    hid_t result;
    
    arg1 = (XdmfInt32)jarg1; 
    result = XdmfTypeToHDF5Type(arg1);
    
    hid_t * resultptr = new hid_t((hid_t &)result);
    *(hid_t **)&jresult = resultptr; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_HDF5TypeToXdmfType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    hid_t arg1 ;
    XdmfInt32 result;
    hid_t *argp1 ;
    
    argp1 = *(hid_t **)&jarg1; 
    if (!argp1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null hid_t");
        return 0;
    }
    arg1 = *argp1; 
    result = (XdmfInt32)HDF5TypeToXdmfType(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTypeToString(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jstring jresult = 0 ;
    XdmfInt32 arg1 ;
    XdmfString result;
    
    arg1 = (XdmfInt32)jarg1; 
    result = (XdmfString)XdmfTypeToString(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_StringToXdmfType(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jint jresult = 0 ;
    XdmfString arg1 ;
    XdmfInt32 result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (XdmfString)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfInt32)StringToXdmfType(arg1);
    
    jresult = (jint)result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTypeToClassString(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jstring jresult = 0 ;
    XdmfInt32 arg1 ;
    XdmfString result;
    
    arg1 = (XdmfInt32)jarg1; 
    result = (XdmfString)XdmfTypeToClassString(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1SELECTALL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1HYPERSLAB(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1COORDINATES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfDataDesc(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfDataDesc *result;
    
    result = (XdmfDataDesc *)new XdmfDataDesc();
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfDataDesc_1Print(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    (arg1)->Print();
    
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SetNumberType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt64 arg3 = (XdmfInt64) 16 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    arg3 = (XdmfInt64)jarg3; 
    result = (XdmfInt32)(arg1)->SetNumberType(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SetNumberTypeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString arg2 ;
    XdmfInt64 arg3 = (XdmfInt64) 16 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (XdmfInt64)jarg3; 
    result = (XdmfInt32)(arg1)->SetNumberTypeFromString(arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetNumberType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetNumberType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetNumberTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfString)(arg1)->GetNumberTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SetShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    result = (XdmfInt32)(arg1)->SetShape(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 *arg2 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfInt64 **)&jarg2; 
    result = (XdmfInt32)(arg1)->GetShape(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetShapeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfString)(arg1)->GetShapeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1CopySelection(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    result = (XdmfInt32)(arg1)->CopySelection(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1CopyShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    result = (XdmfInt32)(arg1)->CopyShape(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1CopyType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    result = (XdmfInt32)(arg1)->CopyType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SetNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->SetNumberOfElements(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SetShapeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetShapeFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SelectAll(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt32)(arg1)->SelectAll();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SelectHyperSlab(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 *arg2 = (XdmfInt64 *) 0 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt64 *arg4 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfInt64 **)&jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    arg4 = *(XdmfInt64 **)&jarg4; 
    result = (XdmfInt32)(arg1)->SelectHyperSlab(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SelectHyperSlabFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString arg2 ;
    XdmfString arg3 ;
    XdmfString arg4 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (XdmfString)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SelectHyperSlabFromString(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetHyperSlab(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 *arg2 = (XdmfInt64 *) 0 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt64 *arg4 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = *(XdmfInt64 **)&jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    arg4 = *(XdmfInt64 **)&jarg4; 
    result = (XdmfInt32)(arg1)->GetHyperSlab(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetHyperSlabAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfString)(arg1)->GetHyperSlabAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SelectCoordinates(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    result = (XdmfInt32)(arg1)->SelectCoordinates(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1SelectCoordinatesFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SelectCoordinatesFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetCoordinates(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 = (XdmfInt64) 0 ;
    XdmfInt64 arg3 = (XdmfInt64) 0 ;
    XdmfInt64 *result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = (XdmfInt64)jarg3; 
    result = (XdmfInt64 *)(arg1)->GetCoordinates(arg2,arg3);
    
    *(XdmfInt64 **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetCoordinatesAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 = (XdmfInt64) 0 ;
    XdmfInt64 arg3 = (XdmfInt64) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = (XdmfInt64)jarg3; 
    result = (XdmfString)(arg1)->GetCoordinatesAsString(arg2,arg3);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetSelectionSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetSelectionSize();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfElements();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetRank(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetRank();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetDimension(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetDimension(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetStart(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetStart(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetStride(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetStride(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetCount(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetSelectionType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetSelectionType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetSelectionTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfString)(arg1)->GetSelectionTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetDataType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    hid_t result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (arg1)->GetDataType();
    
    hid_t * resultptr = new hid_t((hid_t &)result);
    *(hid_t **)&jresult = resultptr; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetDataSpace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    hid_t result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (arg1)->GetDataSpace();
    
    hid_t * resultptr = new hid_t((hid_t &)result);
    *(hid_t **)&jresult = resultptr; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetElementSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetElementSize();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1AddCompoundMemberFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfString arg2 ;
    XdmfString arg3 ;
    XdmfString arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (XdmfString)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = (XdmfInt64)jarg5; 
    result = (XdmfInt32)(arg1)->AddCompoundMemberFromString(arg2,arg3,arg4,arg5);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetNumberOfMembers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfMembers();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfString)(arg1)->GetMemberName(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetMemberLength(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetMemberSize(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    result = (XdmfInt32)(arg1)->GetMemberShape(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberShapeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfString)(arg1)->GetMemberShapeAsString(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->GetMemberType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfString)(arg1)->GetMemberTypeAsString(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDataDesc_1GetMemberOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDataDesc *arg1 = (XdmfDataDesc *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDataDesc **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetMemberOffset(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ARRAY_1IN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ARRAY_1OUT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ARRAY_1TAG_1LENGTH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 80;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfArray(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfArray *result;
    
    result = (XdmfArray *)new XdmfArray();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfArray **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfArray_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    char *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfArray_1GetTagName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    char *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (char *)(arg1)->GetTagName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1GetCoreLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfLength result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfLength)(arg1)->GetCoreLength();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1Allocate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfInt32)(arg1)->Allocate();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    result = (XdmfInt32)(arg1)->SetShape(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetShapeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetShapeFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->SetNumberOfElements(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1ReformFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->ReformFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1CopyShape(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    result = (XdmfInt32)(arg1)->CopyShape(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1GetDataPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 = (XdmfInt64) 0 ;
    XdmfPointer result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfPointer)(arg1)->GetDataPointer(arg2);
    
    *(XdmfPointer *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfArray_1SetDataPointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfPointer arg2 = (XdmfPointer) 0 ;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = *(XdmfPointer *)&jarg2; 
    (arg1)->SetDataPointer(arg2);
    
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValueFromFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat64 arg3 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = (XdmfFloat64)jarg3; 
    result = (XdmfInt32)(arg1)->SetValueFromFloat64(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValueFromInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 arg3 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = (XdmfInt64)jarg3; 
    result = (XdmfInt32)(arg1)->SetValueFromInt64(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString arg3 ;
    XdmfInt64 arg4 = (XdmfInt64) 1 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    result = (XdmfInt32)(arg1)->SetValues(arg2,arg3,arg4,arg5);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValuesAsInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt8 *arg3 = (XdmfInt8 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt8 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->GetValuesAsInt8(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValuesFromInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt8 *arg3 = (XdmfInt8 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt8 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->SetValuesFromInt8(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValuesAsInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 *arg3 = (XdmfInt32 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt32 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->GetValuesAsInt32(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValuesFromInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 *arg3 = (XdmfInt32 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt32 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->SetValuesFromInt32(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValuesAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->GetValuesAsInt64(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValuesFromInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 *arg3 = (XdmfInt64 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfInt64 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->SetValuesFromInt64(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValuesAsFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat32 *arg3 = (XdmfFloat32 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfFloat32 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->GetValuesAsFloat32(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValuesFromFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat32 *arg3 = (XdmfFloat32 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfFloat32 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->SetValuesFromFloat32(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValuesAsFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat64 *arg3 = (XdmfFloat64 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfFloat64 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->GetValuesAsFloat64(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1SetValuesFromFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat64 *arg3 = (XdmfFloat64 *) 0 ;
    XdmfInt64 arg4 ;
    XdmfInt64 arg5 = (XdmfInt64) 1 ;
    XdmfInt64 arg6 = (XdmfInt64) 1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfFloat64 **)&jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    arg6 = (XdmfInt64)jarg6; 
    result = (XdmfInt32)(arg1)->SetValuesFromFloat64(arg2,arg3,arg4,arg5,arg6);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfArray_1GetValueAsFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfFloat64)(arg1)->GetValueAsFloat64(arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jfloat JNICALL Java_XdmfJNI_XdmfArray_1GetValueAsFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jfloat jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfFloat32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfFloat32)(arg1)->GetValueAsFloat32(arg2);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1GetValueAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt64)(arg1)->GetValueAsInt64(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1GetValueAsInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->GetValueAsInt32(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jshort JNICALL Java_XdmfJNI_XdmfArray_1GetValueAsInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jshort jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt8 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt8)(arg1)->GetValueAsInt8(arg2);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfArray_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jstring jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 arg2 = (XdmfInt64) 0 ;
    XdmfInt64 arg3 = (XdmfInt64) 0 ;
    XdmfInt64 arg4 = (XdmfInt64) 1 ;
    XdmfString result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = (XdmfInt64)jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    result = (XdmfString)(arg1)->GetValues(arg2,arg3,arg4);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfArray_1Generate(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jlong jarg4, jlong jarg5) {
    jint jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfFloat64 arg2 ;
    XdmfFloat64 arg3 ;
    XdmfInt64 arg4 = (XdmfInt64) 0 ;
    XdmfInt64 arg5 = (XdmfInt64) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfFloat64)jarg2; 
    arg3 = (XdmfFloat64)jarg3; 
    arg4 = (XdmfInt64)jarg4; 
    arg5 = (XdmfInt64)jarg5; 
    result = (XdmfInt32)(arg1)->Generate(arg2,arg3,arg4,arg5);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1Clone(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfLength arg2 = (XdmfLength) 0 ;
    XdmfLength arg3 = (XdmfLength) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfLength)jarg2; 
    arg3 = (XdmfLength)jarg3; 
    result = (XdmfArray *)(arg1)->Clone(arg2,arg3);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1Reference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfLength arg2 = (XdmfLength) 0 ;
    XdmfLength arg3 = (XdmfLength) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = (XdmfLength)jarg2; 
    arg3 = (XdmfLength)jarg3; 
    result = (XdmfArray *)(arg1)->Reference(arg2,arg3);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfArray_1GetMaxAsFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetMaxAsFloat64();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfArray_1GetMinAsFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetMinAsFloat64();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1GetMaxAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetMaxAsInt64();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfArray_1GetMinAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetMinAsInt64();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfArray_1GetMean(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetMean();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfArray_1SetDataFromChars(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetDataFromChars(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfArray_1GetDataPointerAsCharPointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    char *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    result = (char *)(arg1)->GetDataPointerAsCharPointer();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_set_1XdmfArrayList_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->name) delete [] arg1->name;
        arg1->name = (char *) (new char[strlen(arg2)+1]);
        strcpy((char *) arg1->name,arg2);
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_get_1XdmfArrayList_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    char *result;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    result = (char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_set_1XdmfArrayList_1timecntr(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    XdmfLength arg2 ;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    arg2 = (XdmfLength)jarg2; 
    if (arg1) (arg1)->timecntr = arg2;
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_get_1XdmfArrayList_1timecntr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    XdmfLength result;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    result = (XdmfLength) ((arg1)->timecntr);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_set_1XdmfArrayList_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    if (arg1) (arg1)->Array = arg2;
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_get_1XdmfArrayList_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    result = (XdmfArray *) ((arg1)->Array);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfArrayList(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfArrayList *result;
    
    result = (XdmfArrayList *)new XdmfArrayList();
    
    *(XdmfArrayList **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfArrayList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfArrayList *arg1 = (XdmfArrayList *) 0 ;
    
    arg1 = *(XdmfArrayList **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_TagNameToArray(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    XdmfString arg1 ;
    XdmfArray *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (XdmfString)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfArray *)TagNameToArray(arg1);
    
    *(XdmfArray **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_PrintAllXdmfArrays(JNIEnv *jenv, jclass jcls) {
    PrintAllXdmfArrays();
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_GetNextOlderArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfLength arg1 ;
    XdmfLength *arg2 = (XdmfLength *) NULL ;
    XdmfArray *result;
    
    arg1 = (XdmfLength)jarg1; 
    arg2 = *(XdmfLength **)&jarg2; 
    result = (XdmfArray *)GetNextOlderArray(arg1,arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_GetCurrentArrayTime(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfLength result;
    
    result = (XdmfLength)GetCurrentArrayTime();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfXNode(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfXNode *result;
    
    result = (XdmfXNode *)new XdmfXNode();
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfXNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfXNode_1Set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    char *arg2 ;
    char *arg3 ;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return ;
        }
    }
    (arg1)->Set((char const *)arg2,(char const *)arg3);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfXNode_1Get(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    char *arg2 ;
    char *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)(arg1)->Get((char const *)arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfXNode_1Print(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    (arg1)->Print();
    
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfXNode_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    result = (int)(arg1)->GetSize();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfXNode_1GetNameByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int arg2 ;
    char *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)(arg1)->GetNameByIndex(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfXNode_1GetDataByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int arg2 ;
    char *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)(arg1)->GetDataByIndex(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfXNode_1GetClientData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    void *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    result = (void *)(arg1)->GetClientData();
    
    *(void **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfXNode_1SetClientData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    void *arg2 = (void *) 0 ;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = *(void **)&jarg2; 
    (arg1)->SetClientData(arg2);
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfXNode_1ManualDelete(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    (arg1)->ManualDelete(arg2);
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfParameter(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfParameter *result;
    
    result = (XdmfParameter *)new XdmfParameter();
    
    *(XdmfParameter **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfParameter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    char *result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1GetParameterType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetParameterType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1GetParameterTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfString)(arg1)->GetParameterTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1SetParameterType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetParameterType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfParameter_1GetCurrentIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetCurrentIndex();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1SetCurrentIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->SetCurrentIndex(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1GetParameterName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfString)(arg1)->GetParameterName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1SetParameterName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetParameterName(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfParameter_1GetParameterNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfXNode *result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfXNode *)(arg1)->GetParameterNode();
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1SetParameterNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetParameterNode(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1GetFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfString)(arg1)->GetFormat();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfParameter_1GetNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfElements();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfParameter_1GetArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetArray();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1GetParameterValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    result = (XdmfString)(arg1)->GetParameterValue();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfParameter_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfInt32 arg2 = (XdmfInt32) -1 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->Update(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfParameter_1Substitute(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    XdmfParameter *arg1 = (XdmfParameter *) 0 ;
    XdmfString arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfParameter **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfString)(arg1)->Substitute(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfHeavyData(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfHeavyData *result;
    
    result = (XdmfHeavyData *)new XdmfHeavyData();
    
    *(XdmfHeavyData **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfHeavyData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    char *result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetNdgmHost();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetNdgmHost(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetWorkingDirectory();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetWorkingDirectory(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetDomain(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetDomain();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetDomain(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetDomain(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetFileName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetFileName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetFileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetFileName(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetPath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetPath();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetPath(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHeavyData_1GetAccess(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    result = (XdmfString)(arg1)->GetAccess();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHeavyData_1SetAccess(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHeavyData *arg1 = (XdmfHeavyData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfHeavyData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetAccess(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1H5_1OTHER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0xFF;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfHDF(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfHDF *result;
    
    result = (XdmfHDF *)new XdmfHDF();
    
    *(XdmfHDF **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfHDF(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHDF_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    char *result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1SetCwdName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetCwdName(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHDF_1GetCwdName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    result = (XdmfString)(arg1)->GetCwdName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1Cd(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString arg2 = (XdmfString) "/" ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Cd(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1Mkdir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Mkdir(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfHDF_1GetNumberOfChildren(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfChildren();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHDF_1GetChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfString)(arg1)->GetChild(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfHDF_1SetNextChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetNextChild((char const *)arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1Info(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    hid_t arg2 ;
    char *arg3 ;
    XdmfInt32 result;
    hid_t *argp2 ;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    argp2 = *(hid_t **)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null hid_t");
        return 0;
    }
    arg2 = *argp2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Info(arg2,(char const *)arg3);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1GetChildType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->GetChildType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfHDF_1GetChildTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt64 arg2 ;
    XdmfString result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfString)(arg1)->GetChildTypeAsString(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1CreateDataset(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString arg2 = (XdmfString) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->CreateDataset(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1OpenDataset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    result = (XdmfInt32)(arg1)->OpenDataset();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1Open(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfString arg2 = (XdmfString) NULL ;
    XdmfString arg3 = (XdmfString) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Open(arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfHDF_1Read(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfArray *)(arg1)->Read(arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfHDF_1Write(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfArray *)(arg1)->Write(arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfHDF_1Close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfHDF *arg1 = (XdmfHDF *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfHDF **)&jarg1; 
    result = (XdmfInt32)(arg1)->Close();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_CopyArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfArray **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfArray *)CopyArray(arg1,arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfDOM(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfDOM *result;
    
    result = (XdmfDOM *)new XdmfDOM();
    
    *(XdmfDOM **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfDOM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetXMLVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    float arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = (float)jarg2; 
    result = (XdmfInt32)(arg1)->SetXMLVersion(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jfloat JNICALL Java_XdmfJNI_XdmfDOM_1GetXMLVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    float result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (float)(arg1)->GetXMLVersion();
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetDocType(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetDocType(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetDocType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetDocType();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetSystem(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetSystem(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetSystem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetSystem();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetInputFileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetInputFileName(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetOutputFileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetOutputFileName(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetInputFileName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetInputFileName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetOutputFileName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetOutputFileName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetOutput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    std::ostream *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (std::ostream *)(arg1)->GetOutput();
    
    *(std::ostream **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    std::ostream *arg2 = (std::ostream *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(std::ostream **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetOutput(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetInput(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    std::istream *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (std::istream *)(arg1)->GetInput();
    
    *(std::istream **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1SetInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    std::istream *arg2 = (std::istream *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(std::istream **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetInput(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1GenerateHead(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfInt32)(arg1)->GenerateHead();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1Puts(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Puts(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1GenerateTail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfInt32)(arg1)->GenerateTail();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1Gets(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->Gets();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetTree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XDMF_TREE_NODE *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XDMF_TREE_NODE *)(arg1)->GetTree();
    
    *(XDMF_TREE_NODE **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1_1_1Parse(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XDMF_TREE_NODE *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XDMF_TREE_NODE *)(arg1)->__Parse(arg2);
    
    *(XDMF_TREE_NODE **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1Parse(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 = (XdmfString) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->Parse(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetRoot(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfXNode *)(arg1)->GetRoot();
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetNumberOfChildren(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) NULL ;
    XdmfInt64 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt64)(arg1)->GetNumberOfChildren(arg2);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfInt64 arg2 ;
    XdmfXNode *arg3 = (XdmfXNode *) 0 ;
    XdmfXNode *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfXNode *)(arg1)->GetChild(arg2,arg3);
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1GetNumberOfAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->GetNumberOfAttributes(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 arg3 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = (XdmfInt32)jarg3; 
    result = (XdmfString)(arg1)->GetAttribute(arg2,arg3);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1IsChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfInt32)(arg1)->IsChild(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1Serialize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) NULL ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfString)(arg1)->Serialize(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1Insert(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfXNode *arg3 = (XdmfXNode *) 0 ;
    XdmfInt32 arg4 = (XdmfInt32) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfXNode **)&jarg3; 
    arg4 = (XdmfInt32)jarg4; 
    result = (XdmfInt32)(arg1)->Insert(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1InsertFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfString arg3 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->InsertFromString(arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1DeleteNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->DeleteNode(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1FindElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 ;
    XdmfInt32 arg3 = (XdmfInt32) 0 ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (XdmfInt32)jarg3; 
    arg4 = *(XdmfXNode **)&jarg4; 
    result = (XdmfXNode *)(arg1)->FindElement((char const *)arg2,arg3,arg4);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1FindElementByAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 ;
    char *arg3 ;
    XdmfInt32 arg4 = (XdmfInt32) 0 ;
    XdmfXNode *arg5 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (XdmfInt32)jarg4; 
    arg5 = *(XdmfXNode **)&jarg5; 
    result = (XdmfXNode *)(arg1)->FindElementByAttribute((char const *)arg2,(char const *)arg3,arg4,arg5);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1FindNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfInt32)(arg1)->FindNumberOfElements(arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1FindNumberOfElementsByAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfString arg3 ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = *(XdmfXNode **)&jarg4; 
    result = (XdmfInt32)(arg1)->FindNumberOfElementsByAttribute(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1FindProcessingInstruction(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 = (char *) NULL ;
    XdmfInt32 arg3 = (XdmfInt32) 0 ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (XdmfInt32)jarg3; 
    arg4 = *(XdmfXNode **)&jarg4; 
    result = (XdmfXNode *)(arg1)->FindProcessingInstruction((char const *)arg2,arg3,arg4);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1FindNumberOfProcessingInstructions(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 = (char *) NULL ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfInt32)(arg1)->FindNumberOfProcessingInstructions((char const *)arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetNdgmHost();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfDOM_1SetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetNdgmHost(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    result = (XdmfString)(arg1)->GetWorkingDirectory();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfDOM_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetWorkingDirectory(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfDOM_1Get(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
    jstring jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfString arg3 ;
    XdmfString result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (XdmfString)(arg1)->Get(arg2,arg3);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfDOM_1SetUserData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfPointer arg3 = (XdmfPointer) 0 ;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfPointer *)&jarg3; 
    (arg1)->SetUserData(arg2,arg3);
    
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetUserData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfPointer result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfPointer)(arg1)->GetUserData(arg2);
    
    *(XdmfPointer *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfDOM_1Set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4) {
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfString arg3 ;
    XdmfString arg4 ;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (XdmfString)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return ;
        }
    }
    (arg1)->Set(arg2,arg3,arg4);
    
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1GetNumberType(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->GetNumberType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfDOM_1FindNumberOfParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) NULL ;
    XdmfInt32 result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->FindNumberOfParameters(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1FindParameter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfString arg2 ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfParameter *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfParameter *)(arg1)->FindParameter(arg2,arg3);
    
    *(XdmfParameter **)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfDOM_1GetParameter(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfDOM *arg1 = (XdmfDOM *) 0 ;
    XdmfInt32 arg2 = (XdmfInt32) 0 ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfParameter *result;
    
    arg1 = *(XdmfDOM **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfParameter *)(arg1)->GetParameter(arg2,arg3);
    
    *(XdmfParameter **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_GetXNodeSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    result = (int)GetXNodeSize(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_GetXNodeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int arg2 ;
    char *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)GetXNodeName(arg1,arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_GetXNodeData(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    XdmfXNode *arg1 = (XdmfXNode *) 0 ;
    int arg2 ;
    char *result;
    
    arg1 = *(XdmfXNode **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)GetXNodeData(arg1,arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_HandleToXdmfDOM(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    XdmfDOM *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfDOM *)HandleToXdmfDOM(arg1);
    
    *(XdmfDOM **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfLightData(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfLightData *result;
    
    result = (XdmfLightData *)new XdmfLightData();
    
    *(XdmfLightData **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfLightData_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    char *result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfLightData_1GetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfString)(arg1)->GetNdgmHost();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfLightData_1SetNdgmHost(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    char *arg2 ;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetNdgmHost(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfLightData_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfString)(arg1)->GetName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfLightData_1SetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetName(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfLightData_1GetFileName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfString)(arg1)->GetFileName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfLightData_1SetFileName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetFileName(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfLightData_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfString)(arg1)->GetWorkingDirectory();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfLightData_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetWorkingDirectory(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfLightData_1SetDOM(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfDOM *arg2 = (XdmfDOM *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    arg2 = *(XdmfDOM **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetDOM(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfLightData_1GetDOM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfDOM *result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfDOM *)(arg1)->GetDOM();
    
    *(XdmfDOM **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfLightData_1SetCurrentElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetCurrentElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfLightData_1GetCurrentElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfXNode *result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfXNode *)(arg1)->GetCurrentElement();
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfLightData_1HasBeenInited(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfLightData *arg1 = (XdmfLightData *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfLightData **)&jarg1; 
    result = (XdmfInt32)(arg1)->HasBeenInited();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1MAX_1ORDER(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1STRUCTURED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1UNSTRUCTURED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1NOTOPOLOGY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1POLYVERTEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1POLYLINE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1POLYGON(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1TRI(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1QUAD(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1TET(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1PYRAMID(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1WEDGE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1HEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_12DSMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x0100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_12DRECTMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x0101;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_12DCORECTMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x0102;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_13DSMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x1100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_13DRECTMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x1101;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_13DCORECTMESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0x1102;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfTopology(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfTopology *result;
    
    result = (XdmfTopology *)new XdmfTopology();
    
    *(XdmfTopology **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfTopology(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTopology_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    char *result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1GetClass(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetClass();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTopology_1GetClassAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfString)(arg1)->GetClassAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetTopologyType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetTopologyType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetTopologyTypeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetTopologyTypeFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1GetTopologyType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetTopologyType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTopology_1GetTopologyTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfString)(arg1)->GetTopologyTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTopology_1GetOrder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 *result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32 *)(arg1)->GetOrder();
    
    *(XdmfInt32 **)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTopology_1GetOrderAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfString)(arg1)->GetOrderAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetOrderFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetOrderFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 *arg3 = (XdmfInt32 *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    arg3 = *(XdmfInt32 **)&jarg3; 
    result = (XdmfInt32)(arg1)->SetOrder(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetNodesPerElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetNodesPerElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1GetNodesPerElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetNodesPerElement();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetBaseOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetBaseOffset(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1GetBaseOffset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetBaseOffset();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTopology_1GetShapeDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfDataDesc *result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfDataDesc *)(arg1)->GetShapeDesc();
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTopology_1GetNumberOfElements(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfElements();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1InitTopologyFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->InitTopologyFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetTopologyFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetTopologyFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTopology_1GetConnectivity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfArray *)(arg1)->GetConnectivity(arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1SetConnectivity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetConnectivity(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfTopology_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfTopology *arg1 = (XdmfTopology *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfTopology **)&jarg1; 
    result = (XdmfInt32)(arg1)->Update();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_HandleToXdmfTopology(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    XdmfTopology *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfTopology *)HandleToXdmfTopology(arg1);
    
    *(XdmfTopology **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1TYPE_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1TYPE_1SCALAR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1TYPE_1VECTOR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1TYPE_1TENSOR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1TYPE_1MATRIX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1CENTER_1GRID(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1CENTER_1CELL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1CENTER_1FACE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1CENTER_1EDGE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1ATTRIBUTE_1CENTER_1NODE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfAttribute(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfAttribute *result;
    
    result = (XdmfAttribute *)new XdmfAttribute();
    
    *(XdmfAttribute **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfAttribute_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    char *result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetAttributeType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetAttributeType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1GetAttributeType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetAttributeType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetAttributeTypeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetAttributeTypeFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfAttribute_1GetAttributeTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfString)(arg1)->GetAttributeTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetAttributeCenterFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetAttributeCenterFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfAttribute_1GetAttributeCenterAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfString)(arg1)->GetAttributeCenterAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetAttributeCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetAttributeCenter(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1GetAttributeCenter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetAttributeCenter();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfAttribute_1GetShapeDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfDataDesc *result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfDataDesc *)(arg1)->GetShapeDesc();
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetValues(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfAttribute_1GetValues(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetValues();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1InitAttributeFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->InitAttributeFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1SetAttributeFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetAttributeFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfAttribute_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfAttribute *arg1 = (XdmfAttribute *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfAttribute **)&jarg1; 
    result = (XdmfInt32)(arg1)->Update();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfCharArray(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfCharArray *result;
    
    result = (XdmfCharArray *)new XdmfCharArray();
    
    *(XdmfCharArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfCharArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfCharArray *arg1 = (XdmfCharArray *) 0 ;
    
    arg1 = *(XdmfCharArray **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfCharArray_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfCharArray *arg1 = (XdmfCharArray *) 0 ;
    char *result;
    
    arg1 = *(XdmfCharArray **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfCharArray_1GetString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfCharArray *arg1 = (XdmfCharArray *) 0 ;
    char *result;
    
    arg1 = *(XdmfCharArray **)&jarg1; 
    result = (char *)(arg1)->GetString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfCharArray_1SetString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfCharArray *arg1 = (XdmfCharArray *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfCharArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfCharArray_1SetFromFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfCharArray *arg1 = (XdmfCharArray *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfCharArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetFromFile(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfFormat(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfFormat *result;
    
    result = (XdmfFormat *)new XdmfFormat();
    
    *(XdmfFormat **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormat_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    char *result;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfFormat_1SetFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetFormat(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormat_1GetFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    result = (XdmfString)(arg1)->GetFormat();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormat_1ElementToDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *result;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfDataDesc *)(arg1)->ElementToDataDesc(arg2);
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormat_1ElementToCompoundDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *result;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfDataDesc *)(arg1)->ElementToCompoundDataDesc(arg2);
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormat_1DataDescToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    XdmfFormat *arg1 = (XdmfFormat *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfXNode *arg3 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfFormat **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    arg3 = *(XdmfXNode **)&jarg3; 
    result = (XdmfXNode *)(arg1)->DataDescToElement(arg2,arg3);
    
    *(XdmfXNode **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfFormatXML(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfFormatXML *result;
    
    result = (XdmfFormatXML *)new XdmfFormatXML();
    
    *(XdmfFormatXML **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfFormatXML(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfFormatXML *arg1 = (XdmfFormatXML *) 0 ;
    
    arg1 = *(XdmfFormatXML **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormatXML_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfFormatXML *arg1 = (XdmfFormatXML *) 0 ;
    char *result;
    
    arg1 = *(XdmfFormatXML **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatXML_1ElementToArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfFormatXML *arg1 = (XdmfFormatXML *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *arg3 = (XdmfDataDesc *) NULL ;
    XdmfArray *arg4 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfFormatXML **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfDataDesc **)&jarg3; 
    arg4 = *(XdmfArray **)&jarg4; 
    result = (XdmfArray *)(arg1)->ElementToArray(arg2,arg3,arg4);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatXML_1ArrayToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    XdmfFormatXML *arg1 = (XdmfFormatXML *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfString arg3 = (XdmfString) NULL ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfDataDesc *arg5 = (XdmfDataDesc *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfFormatXML **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = *(XdmfXNode **)&jarg4; 
    arg5 = *(XdmfDataDesc **)&jarg5; 
    result = (XdmfXNode *)(arg1)->ArrayToElement(arg2,arg3,arg4,arg5);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfFormatHDF(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfFormatHDF *result;
    
    result = (XdmfFormatHDF *)new XdmfFormatHDF();
    
    *(XdmfFormatHDF **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfFormatHDF(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfFormatHDF *arg1 = (XdmfFormatHDF *) 0 ;
    
    arg1 = *(XdmfFormatHDF **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormatHDF_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfFormatHDF *arg1 = (XdmfFormatHDF *) 0 ;
    char *result;
    
    arg1 = *(XdmfFormatHDF **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatHDF_1ElementToArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfFormatHDF *arg1 = (XdmfFormatHDF *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *arg3 = (XdmfDataDesc *) NULL ;
    XdmfArray *arg4 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfFormatHDF **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfDataDesc **)&jarg3; 
    arg4 = *(XdmfArray **)&jarg4; 
    result = (XdmfArray *)(arg1)->ElementToArray(arg2,arg3,arg4);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatHDF_1ArrayToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    XdmfFormatHDF *arg1 = (XdmfFormatHDF *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfString arg3 = (XdmfString) NULL ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfDataDesc *arg5 = (XdmfDataDesc *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfFormatHDF **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = *(XdmfXNode **)&jarg4; 
    arg5 = *(XdmfDataDesc **)&jarg5; 
    result = (XdmfXNode *)(arg1)->ArrayToElement(arg2,arg3,arg4,arg5);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfFormatMulti(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfFormatMulti *result;
    
    result = (XdmfFormatMulti *)new XdmfFormatMulti();
    
    *(XdmfFormatMulti **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfFormatMulti(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfFormatMulti *arg1 = (XdmfFormatMulti *) 0 ;
    
    arg1 = *(XdmfFormatMulti **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormatMulti_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfFormatMulti *arg1 = (XdmfFormatMulti *) 0 ;
    char *result;
    
    arg1 = *(XdmfFormatMulti **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfFormatMulti_1SetFormatFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jstring jresult = 0 ;
    XdmfFormatMulti *arg1 = (XdmfFormatMulti *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfFormatMulti **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfString)(arg1)->SetFormatFromElement(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatMulti_1ElementToArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfFormatMulti *arg1 = (XdmfFormatMulti *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *arg3 = (XdmfDataDesc *) NULL ;
    XdmfArray *arg4 = (XdmfArray *) NULL ;
    XdmfArray *result;
    
    arg1 = *(XdmfFormatMulti **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    arg3 = *(XdmfDataDesc **)&jarg3; 
    arg4 = *(XdmfArray **)&jarg4; 
    result = (XdmfArray *)(arg1)->ElementToArray(arg2,arg3,arg4);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfFormatMulti_1ArrayToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    XdmfFormatMulti *arg1 = (XdmfFormatMulti *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfString arg3 = (XdmfString) NULL ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfDataDesc *arg5 = (XdmfDataDesc *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfFormatMulti **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = *(XdmfXNode **)&jarg4; 
    arg5 = *(XdmfDataDesc **)&jarg5; 
    result = (XdmfXNode *)(arg1)->ArrayToElement(arg2,arg3,arg4,arg5);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1NONE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1XYZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1XY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1X_1Y_1Z(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1VXVYVZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_get_1XDMF_1GEOMETRY_1ORIGIN_1DXDYDZ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfGeometry(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfGeometry *result;
    
    result = (XdmfGeometry *)new XdmfGeometry();
    
    *(XdmfGeometry **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfGeometry_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    char *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetNumberOfPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->SetNumberOfPoints(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetNumberOfPoints(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetNumberOfPoints();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetGeometryType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt32 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = (XdmfInt32)jarg2; 
    result = (XdmfInt32)(arg1)->SetGeometryType(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1GetGeometryType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetGeometryType();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfGeometry_1GetGeometryTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfString)(arg1)->GetGeometryTypeAsString();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetGeometryTypeFromString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->SetGeometryTypeFromString(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1InitGeometryFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->InitGeometryFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetGeometryFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetGeometryFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetPoints(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetPoints(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetPoints();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64 *)(arg1)->GetOrigin();
    
    *(XdmfFloat64 **)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetOriginX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetOriginX();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetOriginY(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetOriginY();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetOriginZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetOriginZ();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 arg2 ;
    XdmfFloat64 arg3 ;
    XdmfFloat64 arg4 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = (XdmfFloat64)jarg2; 
    arg3 = (XdmfFloat64)jarg3; 
    arg4 = (XdmfFloat64)jarg4; 
    result = (XdmfInt32)(arg1)->SetOrigin(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1SetDxDyDz(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 arg2 ;
    XdmfFloat64 arg3 ;
    XdmfFloat64 arg4 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = (XdmfFloat64)jarg2; 
    arg3 = (XdmfFloat64)jarg3; 
    arg4 = (XdmfFloat64)jarg4; 
    result = (XdmfInt32)(arg1)->SetDxDyDz(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetDx(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetDx();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetDy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetDy();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_XdmfJNI_XdmfGeometry_1GetDz(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64)(arg1)->GetDz();
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetDxDyDz(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfFloat64 *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfFloat64 *)(arg1)->GetDxDyDz();
    
    *(XdmfFloat64 **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetVectorX(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetVectorX();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetVectorY(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetVectorY();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGeometry_1GetVectorZ(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfArray *)(arg1)->GetVectorZ();
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfGeometry_1SetVectorX(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    (arg1)->SetVectorX(arg2);
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfGeometry_1SetVectorY(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    (arg1)->SetVectorY(arg2);
    
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfGeometry_1SetVectorZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    (arg1)->SetVectorZ(arg2);
    
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1HasData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfInt32)(arg1)->HasData();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGeometry_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfGeometry *arg1 = (XdmfGeometry *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGeometry **)&jarg1; 
    result = (XdmfInt32)(arg1)->Update();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_GetXdmfGeometryHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    XdmfGeometry *result;
    
    arg1 = *(void **)&jarg1; 
    result = (XdmfGeometry *)GetXdmfGeometryHandle(arg1);
    
    *(XdmfGeometry **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfGrid(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfGrid *result;
    
    result = (XdmfGrid *)new XdmfGrid();
    
    *(XdmfGrid **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfGrid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfGrid_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    char *result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1SetGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfGeometry *arg2 = (XdmfGeometry *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = *(XdmfGeometry **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetGeometry(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGrid_1GetGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfGeometry *result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfGeometry *)(arg1)->GetGeometry();
    
    *(XdmfGeometry **)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1GetNumberOfAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfInt32)(arg1)->GetNumberOfAttributes();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGrid_1GetAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt64 arg2 ;
    XdmfAttribute *result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfAttribute *)(arg1)->GetAttribute(arg2);
    
    *(XdmfAttribute **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGrid_1GetBaseGrid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfPointer result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfPointer)(arg1)->GetBaseGrid();
    
    *(XdmfPointer *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1AssignAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->AssignAttribute(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1AssignAttributeByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt64 arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = (XdmfInt64)jarg2; 
    result = (XdmfInt32)(arg1)->AssignAttributeByIndex(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1AssignAttributeByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfString arg2 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (XdmfInt32)(arg1)->AssignAttributeByName(arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGrid_1GetAssignedAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfAttribute *result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfAttribute *)(arg1)->GetAssignedAttribute();
    
    *(XdmfAttribute **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfGrid_1GetAssignedAttributeIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt64 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfInt64)(arg1)->GetAssignedAttributeIndex();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1InitGridFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->InitGridFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1SetGridFromElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfInt32)(arg1)->SetGridFromElement(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_XdmfJNI_XdmfGrid_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XdmfGrid *arg1 = (XdmfGrid *) 0 ;
    XdmfInt32 result;
    
    arg1 = *(XdmfGrid **)&jarg1; 
    result = (XdmfInt32)(arg1)->Update();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_HandleToXdmfGrid(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    XdmfGrid *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfGrid *)HandleToXdmfGrid(arg1);
    
    *(XdmfGrid **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfArrayExpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfString arg2 ;
    XdmfArray *arg3 = (XdmfArray *) 0 ;
    
    arg1 = *(XdmfArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = *(XdmfArray **)&jarg3; 
    XdmfArrayExpr(arg1,arg2,arg3);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfScalarExpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    XdmfArray *arg1 = (XdmfArray *) 0 ;
    XdmfString arg2 ;
    XdmfFloat64 arg3 ;
    
    arg1 = *(XdmfArray **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (XdmfFloat64)jarg3; 
    XdmfScalarExpr(arg1,arg2,arg3);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfExpr(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    XdmfString arg1 ;
    XdmfArray *result;
    
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (XdmfString)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (XdmfArray *)XdmfExpr(arg1);
    
    *(XdmfArray **)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_new_1XdmfTransform(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    XdmfTransform *result;
    
    result = (XdmfTransform *)new XdmfTransform();
    
    *(XdmfTransform **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_delete_1XdmfTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTransform_1GetClassName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    char *result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    result = (char *)(arg1)->GetClassName();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_XdmfJNI_XdmfTransform_1SetTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfString arg2 ;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (XdmfString)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    (arg1)->SetTransform(arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_XdmfJNI_XdmfTransform_1GetTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfString result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    result = (XdmfString)(arg1)->GetTransform();
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTransform_1ElementToDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfDataDesc *result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfDataDesc *)(arg1)->ElementToDataDesc(arg2);
    
    *(XdmfDataDesc **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTransform_1ElementToArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfXNode *arg2 = (XdmfXNode *) 0 ;
    XdmfArray *result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    arg2 = *(XdmfXNode **)&jarg2; 
    result = (XdmfArray *)(arg1)->ElementToArray(arg2);
    
    *(XdmfArray **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTransform_1DataDescToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfDataDesc *arg2 = (XdmfDataDesc *) 0 ;
    XdmfString arg3 ;
    XdmfXNode *arg4 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    arg2 = *(XdmfDataDesc **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = *(XdmfXNode **)&jarg4; 
    result = (XdmfXNode *)(arg1)->DataDescToElement(arg2,arg3,arg4);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_XdmfTransform_1ArrayToElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    XdmfTransform *arg1 = (XdmfTransform *) 0 ;
    XdmfArray *arg2 = (XdmfArray *) 0 ;
    XdmfString arg3 ;
    XdmfString arg4 ;
    XdmfXNode *arg5 = (XdmfXNode *) NULL ;
    XdmfXNode *result;
    
    arg1 = *(XdmfTransform **)&jarg1; 
    arg2 = *(XdmfArray **)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (XdmfString)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (XdmfString)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = *(XdmfXNode **)&jarg5; 
    result = (XdmfXNode *)(arg1)->ArrayToElement(arg2,arg3,arg4,arg5);
    
    *(XdmfXNode **)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfDataDescToXdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfObject **)&baseptr = (XdmfDataDesc *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfArrayToXdmfDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfDataDesc **)&baseptr = (XdmfArray *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfXNodeToXdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfObject **)&baseptr = (XdmfXNode *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfParameterToXdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfObject **)&baseptr = (XdmfParameter *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfHeavyDataToXdmfDataDesc(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfDataDesc **)&baseptr = (XdmfHeavyData *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfHDFToXdmfHeavyData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfHeavyData **)&baseptr = (XdmfHDF *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfDOMToXdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfObject **)&baseptr = (XdmfDOM *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfLightDataToXdmfObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfObject **)&baseptr = (XdmfLightData *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfTopologyToXdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfLightData **)&baseptr = (XdmfTopology *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfAttributeToXdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfLightData **)&baseptr = (XdmfAttribute *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfCharArrayToXdmfArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfArray **)&baseptr = (XdmfCharArray *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfFormatToXdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfLightData **)&baseptr = (XdmfFormat *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfFormatXMLToXdmfFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfFormat **)&baseptr = (XdmfFormatXML *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfFormatHDFToXdmfFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfFormat **)&baseptr = (XdmfFormatHDF *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfFormatMultiToXdmfFormat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfFormat **)&baseptr = (XdmfFormatMulti *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfGeometryToXdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfLightData **)&baseptr = (XdmfGeometry *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfGridToXdmfTopology(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfTopology **)&baseptr = (XdmfGrid *)*(void**)&jarg1;
    return baseptr;
}

JNIEXPORT jlong JNICALL Java_XdmfJNI_SWIGXdmfTransformToXdmfLightData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    *(XdmfLightData **)&baseptr = (XdmfTransform *)*(void**)&jarg1;
    return baseptr;
}

#ifdef __cplusplus
}
#endif

