""""""
import datetime
import imp
import os
import warnings
print('loading', os.path.basename(__file__))

import smtk
import smtk.attribute
import smtk.model

from .cardformat import CardFormat
from .namelist import Namelist

# Base class
from . import basewriter
imp.reload(basewriter)
from .basewriter import BaseWriter

card = CardFormat
genre_format_table = {
  'CHAPARRAL': [
    card('blocking_enclosure', item_path='blocking_enclosure'),
    card('partial_enclosure', item_path='partial_enclosure',
      use_condition_for_boolean='partial_enclosure'),
    card('partial_area', item_path='partial_enclosure/partial_area'),
    card('bsp_max_tree_depth', item_path='bsp_max_tree_depth'),
    card('bsp_min_leaf_length', item_path='bsp_min_leaf_length'),
    card('spatial_tolerance', item_path='spatial_tolerance'),
    card('hemicube_resolution', item_path='hemicube_resolution'),
    card('min_separation', item_path='min_separation'),
    card('max_subdivisions', item_path='max_subdivisions'),
    card('smoothing_tolerance', item_path='smoothing_tolerance'),
    card('smoothing_max_iter', item_path='smoothing_max_iter'),
    card('smoothing_weight', item_path='smoothing_weight'),
    card('verbosity_level', item_path='verbosity_level')
  ],
  'ENCLOSURE': [
    card('name', use_name_for_value=True),
    card('mesh_file', is_custom=True),
    card('coord_scale_factor', att_type="mesh", item_path='coordinate-scale-factor'),
    card('symmetries', item_path='symmetries', is_custom=True),
    card('side_set_ids', use_model_entities_for_value=True),
    card('ignore_block_ids', att_type='ignore-blocks', use_model_entities_for_value=True, is_custom=True)
  ],
}


class GenreWriter(BaseWriter):
    """Writer for Genre input files"""
# ---------------------------------------------------------------------
    def __init__(self, export_params, mesh_filename='NOT-FOUND', altmesh_filename=None):
        """"""
        BaseWriter.__init__(self, export_params, mesh_filename, altmesh_filename)
        self.output_folder = None

        # Initialize output folder
        # Get the output folder item
        analysis_item = export_params.findString('analysis-code')
        output_dir_item = analysis_item.find('output-folder', smtk.attribute.SearchStyle.RECURSIVE)
        self.output_folder = output_dir_item.value(0)

        # Create output folder if needed
        if not os.path.exists(self.output_folder):
            os.makedirs(self.output_folder)

# ---------------------------------------------------------------------
    def write(self, path):
        """Write genre input file for each 'Enclosure' attribute.

        Must return boolean indicating success.
        """
        # Write .inp file for each enclosure attribute
        att_list = self.sim_atts.findAttributes('enclosure')
        for att in att_list:
            self._check_attribute(att)

            # Create output file based on attribute name
            filename = '{}.inp'.format(att.name())
            path = os.path.join(self.output_folder, filename)
            print('Writing Genre input file', path)
            with open(path, 'wt') as self.out:
                for namelist in ['ENCLOSURE', 'CHAPARRAL']:
                    format_list = genre_format_table.get(namelist)
                    self._start_namelist(namelist)
                    for card in format_list:
                        if card.keyword == 'symmetries':
                            self._write_symmetries(card, att)
                        elif card.keyword == 'mesh_file':
                            CardFormat.write_value(self.out, card.keyword, self.mesh_file)
                        elif card.keyword == 'ignore_block_ids':
                            # Check for associations
                            ignore_att = self._find_instanced_attribute(card.att_type)
                            ref_item = ignore_att.associations()
                            if ref_item.numberOfValues() > 0:
                                id_string = CardFormat.get_model_entity_ids(ref_item, as_string=True)
                                CardFormat.write_value(self.out, card.keyword, id_string, quote_string=False)
                        elif card.att_type is not None and card.att_type != att.type():
                            self._write_instanced_attribute(card)
                        else:
                            card.write(self.out, att)
                    self._finish_namelist()
        return True

    def _write_symmetries(self, card, att):
        """Custom logic for symmetries card"""
        symm_list = list()
        symm_group = att.findGroup('symmetries')

        # Check mirror xyz
        for c in 'xyz':
            item_name = 'mirror-{}'.format(c)
            item = symm_group.find(item_name)
            if item.isEnabled():
                symm_name = 'Mirror{}'.format(c.upper())
                symm_list.append(symm_name)

        # Check for rotation
        rot_item = symm_group.find('rotation')
        if rot_item is not None and rot_item.isEnabled():
            axis_item = rot_item.find('symmetry-axis')
            axis = axis_item.value()
            order_item = rot_item.find('order')
            order = order_item.value()
            rot_name = 'Rot{}{}'.format(axis, order)
            symm_list.append(rot_name)

        if symm_list:
            CardFormat.write_value(self.out, card.keyword, symm_list)
