//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//=============================================================================
#include "smtk/simulation/truchas/utility/MaterialAttributeUtils.h"

#include "smtk/attribute/Attribute.h"
#include "smtk/attribute/GroupItem.h"
#include "smtk/attribute/ItemDefinition.h"
#include "smtk/attribute/ValueItem.h"

namespace smtk
{
namespace simulation
{
namespace truchas
{

bool MaterialAttributeUtils::configureNewAttribute(smtk::attribute::AttributePtr att) const
{
  // Todo
  auto phasesGroup = att->findGroup("phases");
    for (std::size_t i = 0; i < phasesGroup->numberOfItemsPerGroup(); ++i)
    {
      smtk::attribute::ItemPtr phaseItem = phasesGroup->item(i);
      // Todo set the forceRequired flag
    } // for (i)

  return true;
}

bool MaterialAttributeUtils::addPhase(smtk::attribute::AttributePtr att) const
{
  auto phasesGroup = att->findGroup("phases");
  auto transitionsGroup = att->findGroup("transitions");
  auto sharedGroup = att->findGroup("shared-properties");

  phasesGroup->appendGroup();
  transitionsGroup->appendGroup();

  if (phasesGroup->numberOfGroups() == 2)
  {
    // Copy valid phase 1 items to shared-properties
    for (std::size_t i = 0; i < phasesGroup->numberOfItemsPerGroup(); ++i)
    {
      smtk::attribute::ItemPtr phaseItem = phasesGroup->item(i);

      // Todo set the forceRequired flag by default
      // phaseItem->setForceRequired(true);

      if (!phaseItem->isValid())
      {
        continue;
      }

      auto sharedItem = sharedGroup->find(phaseItem->name());
      if (sharedItem == nullptr)
      {
        continue;
      }

      // Copy phase 1 item to shared item
      sharedItem->setIsEnabled(true);
      smtk::attribute::ConstItemPtr constPhaseItem = phasesGroup->item(i);
      if (!sharedItem->assign(constPhaseItem, 0))
      {
        std::cerr << "Failed to assign shared item" << sharedItem->name() << std::endl;
        continue;
      }

      // Unset the phase item, making it invalid and thus not enabled
      auto valItem = std::dynamic_pointer_cast<smtk::attribute::ValueItem>(phaseItem);
      if (valItem != nullptr)
      {
        valItem->unset(0);
      }

      // Todo clear forceRequired flag on the phase item
      // phaseItem->setForceRequired(false);
    } // for (i)
  }   // if (2 phases)

  // Set the forceRequired state for each item in the new phase
  std::size_t newPhaseNumber = phasesGroup->numberOfGroups() - 1;
  for (std::size_t i = 0; i < phasesGroup->numberOfItemsPerGroup(); ++i)
  {
    smtk::attribute::ItemPtr phaseItem = phasesGroup->item(newPhaseNumber, i);
    auto sharedItem = sharedGroup->find(phaseItem->name());
    bool required = sharedItem == nullptr || !sharedItem->isEnabled();
    // Todo set forceRequired state
    // phaseItem->setForceRequired(required);
  }

  return true;
}

bool MaterialAttributeUtils::removePhase(smtk::attribute::AttributePtr att, std::size_t phase) const
{
  auto phasesGroup = att->findGroup("phases");
  auto transitionsGroup = att->findGroup("transitions");

  phasesGroup->removeGroup(phase);
  std::size_t transition = phase == 0 ? 0 : phase - 1;
  transitionsGroup->removeGroup(transition);

  if (phasesGroup->numberOfGroups() > 1)
  {
    return true;
  }

  // If only 1 phase left
  //   - make all items non-optional
  //   - copy any shared item values to phase 1
  auto sharedGroup = att->findGroup("shared-properties");

  for (std::size_t i = 0; i < phasesGroup->numberOfItemsPerGroup(); ++i)
  {
    smtk::attribute::ItemPtr item = phasesGroup->item(i);

    // TOdo make item non-optional
    // item->setForceRequired(false);

    if (item->isValid())
    {
      continue;
    }

    // For nonvalid items, see if there is a valid shared item we can copy
    smtk::attribute::ConstItemPtr sharedItem = sharedGroup->find(item->name());
    if ((sharedItem != nullptr) && sharedItem->isEnabled() && sharedItem->isValid())
    {
      item->assign(sharedItem);
    }
  } // for (item)

  return true;
}

bool MaterialAttributeUtils::enableSharedItem(smtk::attribute::ItemPtr sharedItem, bool enabled) const
{
  sharedItem->setIsEnabled(enabled);
  auto phasesGroup = sharedItem->attribute()->findGroup("phases");

  // Update required state for all phase items of same name
  bool required = !enabled;
  std::string propName = sharedItem->name();
  for (std::size_t i = 0; i < phasesGroup->numberOfGroups(); ++i)
  {
    auto propItem = phasesGroup->find(i, propName);
    // Todo set force-required state
    // propItem->setForceRequired(required);
  }
  return true;
}


bool MaterialAttributeUtils::isValid(smtk::attribute::AttributePtr att) const
{
  return false;
}

bool MaterialAttributeUtils::isValid(smtk::attribute::AttributePtr att,
  const std::set<std::string>& categories, std::string& reason) const
{
  return false;
}
}
}
}
