// Copyright 2016 Kitware, Inc.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

#![warn(missing_docs)]

//! Kitware workflow
//!
//! This crate implements actions which are part of the Kitware development workflow. This includes
//! things such as applying hook checks to a commit, merging branches, handling testing commands,
//! and so on. See the documentation for the various actions for more information.

#[cfg(test)]
#[macro_use]
extern crate lazy_static;

#[macro_use]
extern crate log;

#[macro_use]
extern crate quick_error;

pub mod actions;
pub mod host;
